% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{repression_victims_tbl_df}
\alias{repression_victims_tbl_df}
\title{Argentina Repression Victims}
\format{
A tibble with 8,753 observations and 20 variables:
\describe{
  \item{id_unico_ruvte}{Unique RUVTE identifier}
  \item{anio_denuncia}{Year of report}
  \item{tipificacion_ruvte}{Legal classification}
  \item{apellido_paterno_nombres}{Surname(s) and given name(s)}
  \item{apellido_materno}{Maternal surname}
  \item{apellido_casada}{Married surname}
  \item{edad_al_momento_del_hecho}{Age at time of the event}
  \item{documentos}{Document numbers}
  \item{anio_nacimiento}{Year of birth}
  \item{provincia_nacimiento}{Province of birth}
  \item{pais_nacimiento}{Country of birth}
  \item{nacionalidad}{Nationality}
  \item{embarazo}{Pregnancy status}
  \item{fecha_detencion_secuestro}{Date of arrest or abduction}
  \item{lugar_detencion_secuestro}{Place of arrest or abduction}
  \item{fecha_asesinato_o_hallazgo_de_restos}{Date of murder or discovery of remains}
  \item{lugar_asesinato_o_hallazgo_de_restos}{Place of murder or discovery of remains}
  \item{fotografia}{Availability of photograph}
  \item{provincia_nacimiento_indec_id}{INDEC code for province of birth}
  \item{pais_nacimiento_indec_id}{INDEC code for country of birth}
}
}
\source{
Based on data from the presentes package (version 0.1.0).
Available at: \url{https://datos.jus.gob.ar/dataset/registro-unificado-de-victimas-del-terrorismo-de-estado-ruvte}
}
\usage{
data(repression_victims_tbl_df)
}
\description{
This dataset, repression_victims_tbl_df, is a tibble listing individuals who were victims of illegal state repression
during Argentina’s last dictatorship. It includes information such as names, birthplaces, nationality, dates and locations
of detention or disappearance, and whether the individual was pregnant at the time.
}
\details{
The dataset name has been kept as 'repression_victims_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ArgentinAPI package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble. The original content has not been modified
in any way.
}
