% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constant_weights.R
\name{constant_weights}
\alias{constant_weights}
\title{Returns constant weights for static asset allocations}
\usage{
constant_weights(strat, reb_date = NULL, P, R, risk_free)
}
\arguments{
\item{strat}{A list representing an asset allocation strategy.}

\item{reb_date}{A date on which the allocation rule is applied.}

\item{P}{An xts object with daily prices of the tickers in strat.}

\item{R}{An xts object with daily returns of the tickers in strat.}

\item{risk_free}{Either an xts object with daily returns of the risk-free
asset, or a scalar numeric with the annual risk-free rate in decimals.}
}
\value{
A numeric vector of weights after applying the rule.
}
\description{
\code{constant_weights} applies the identity function to the default weights
in a strategy.
}
\examples{
us_60_40  <- asset_allocations$static$us_60_40
reb_date <- as.Date("2022-03-31")
constant_weights(us_60_40,
                 reb_date,
                 ETFs$Prices[, us_60_40$tickers],
                 ETFs$Returns[, us_60_40$tickers],
                 ETFs$risk_free)
}
