% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anatomicalmassprop.R
\name{massprop_torso}
\alias{massprop_torso}
\title{Torso and leg mass properties}
\usage{
massprop_torso(
  m_true,
  m_legs,
  w_max,
  h_max,
  l_bmax,
  w_leg,
  l_leg,
  l_tot,
  CG_true_x,
  CG_true_z,
  start,
  end
)
}
\arguments{
\item{m_true}{Mass of the torso and legs - no tail (kg)}

\item{m_legs}{Mass of the legs only (kg)}

\item{w_max}{Maximum width of the body (m)}

\item{h_max}{Maximum height of the body (m)}

\item{l_bmax}{x location of the maximum width of the body (m)}

\item{w_leg}{width of the body at leg insertion (m)}

\item{l_leg}{x location of the leg insertion point (m)}

\item{l_tot}{length of body from clavicle to beginning of the tail (m)}

\item{CG_true_x}{x location of the CG for the torso and legs,
origin is at the VRP, measured positive if aft of the VRP (m)}

\item{CG_true_z}{z location of the CG for the torso and legs,
origin is at the VRP (m)}

\item{start}{a 1x3 vector (x,y,z) representing the 3D point where torso starts.
Frame of reference: VRP | Origin: VRP}

\item{end}{a 1x3 vector (x,y,z) representing the 3D point where tail ends.
Frame of reference: VRP | Origin: VRP}
}
\value{
This function returns a list that includes:
\itemize{
\item{I}{a 3x3 matrix representing the moment of inertia tensor of the
torso and leg composite body}
\item{CG}{a 1x3 vector representing the center of gravity position of the
torso and leg composite body}
\item{m}{a double that returns the mass of the torso and leg composite body}
}
}
\description{
Calculate the moment of inertia of a head modeled as a solid cone
}
\section{Warning}{

Parallel axis theorem does not apply between two arbitrary points.
One point must be the object's center of gravity.
}

\examples{
# refer to the vignette
library(AvInertia)

# load data
data(dat_id_curr, package = "AvInertia")
data(dat_bird_curr, package = "AvInertia")
data(dat_feat_curr, package = "AvInertia")
data(dat_bone_curr, package = "AvInertia")
data(dat_mat, package = "AvInertia")
data(clean_pts, package = "AvInertia")

# 1. Determine the center of gravity of the bird's torso (including the legs)
dat_torsotail_out = massprop_restbody(dat_id_curr, dat_bird_curr)
# 2. Calculate the inertia of the flight feathers about the tip of the calamus
feather_inertia <- compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
# 3. Determine the center of gravity of one of the bird's wings
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = 0)
# Visualize the center of gravity of each wing component in the x and y axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yx")
# or the y and z axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yz")
# 4. Combine all data and obtain the center of gravity, moment of inertia
# and principal axes of the bird
curr_full_bird      = combine_inertialprop(dat_torsotail_out,dat_wing_out,
dat_wing_out, dat_id_curr, dat_bird_curr, symmetric=TRUE)

}
\author{
Christina Harvey
}
