\name{SummaryAccuracy}
\alias{SummaryAccuracy}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Summary of the Accuracy of Node and Network selection
}
\description{
This function is to summarize the accuracy of node and Network selection achieved by the functions \code{Networks.STD} and \code{Networks.Fast}. This function is designed to validate whether the settings of arguments are appropriate for one simulation study and provide insights of setting arguments for real data.
}
\usage{SummaryAccuracy(Trace,No.Sets,
Type.Accuracy=c("Node","Sub-network"),True.Node,
TruePositive.Net,FalsePositive.Net,
Type.Net.Accuracy=c("Marginal","Sample"),Tolerance)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{Trace}{the trace (results of each iteration) generated by the functions \code{Networks.STD()} and \code{Networks.Fast()}.
    For \code{Networks.STD()} and \code{Networks.Fast()}, set \code{Trace=total$trace} where \code{total} is the output of the two functions, \code{Networks.STD()} and \code{Networks.Fast()}.
  Use \code{rbind()} bind the inputs if you have multiple sets of results}
  \item{No.Sets}{number of sets of results you put in the argument \code{Trace}}
  \item{Type.Accuracy}{character taking value "Node" or "Sub-network". 
  "Node" represents checking the accuracy of each node; "Sub-network" represents checking the accuracy of network of interest}
  \item{True.Node}{a binary(0/1) vector providing the information of each node. The length of vector should be equal to the length of the vector of \code{pvalue} }
  \item{TruePositive.Net}{a vector representing the network of interest consisted of assumed positive nodes. 
  For example, if you assume No.6,No.8 and No.9 nodes consist the network of interest, set \code{TruePositive.Net=c(6,8,9)}}
  \item{FalsePositive.Net}{a vector representing the assumed negative nodes which would lead false positive networking (larger network) if such nodes are assumed positive in the results.
  Such nodes should be connected to the network of interest and assumed negative.
  For example, if you assume No.3  and No.11 nodes would lead false positive networking (larger network), set \code{TruePositive.Net=c(3,11)}}
  \item{Type.Net.Accuracy}{character taking value "Marginal" or "Sample". "Marginal" represents using marginal distribution of each data-set for checking accuracy, 
for example, if the probability (mean) of one node of a data-set is larger than 0.5, we consider it positive, otherwise, negative. Setting "Sample" represents checking accuracy through each iteration. For \code{Type.Accuracy="Node"}, 
only when 
\code{Type.Net.Accuracy="Sample"},
is valid.}
  \item{Tolerance}{percentage of the Tolerance rate of accuracy. This argument is only valid when set \code{Type.Accuracy="Networking"}. Setting \code{Tolerance=0.9} means we consider selecting a correct networking selection if more than 0.9 positive nodes of networking or \code{TruePositive.Net} are considered as positive
AND less than 0.1 negative nodes of networking or \code{FalsePositive.Net} are considered as positive.}



}

\value{a list of values containing the information of accuracy of nodes and network selection
\describe{
\item{TPR.average}{The Average of True Positive Rate}
\item{FPR.average}{The Average of True False Rate}
\item{FDR.average}{The Average of False Positive Rate}
\item{TPR}{True Positive Rate of each node}
\item{FPR}{False Positive Rate of each node}


}
}
\references{
Yize Zhao, Jian Kang, Tianwei Yu (2014) A Bayesian nonparameteric model for selecting gene and gene sub network, Annals of Applied Statistics, in press. 

Zhou Lan, Jian Kang, Tianwei Yu, Yize Zhao, BANFF: an R package for network identifications via Bayesian nonparametric mixture models, working paper.
}
\author{
Zhou Lan, Jian Kang, Tianwei Yu and Yize Zhao


Department of Biostatistics and Bioinformatics, Emory University}

\examples{
####Gene Network discovery
##Generating Scale free Gene Network
library(igraph)
library(BANFF)
g <- barabasi.game(50, power=1, zero.appeal=1.5,directed = FALSE)
net=as(get.adjacency(g,attr=NULL),"matrix")
##Random assign selected genes and make the signal intension as gaussian mixture
newz=rep(c(1,0,0,1,0),10)
Simnorm=function(n){
weight = c(0.4, 0.6)
mu = c(8,6)
sigma = c(1,0.5)
z = sample(c(1,2),size=n, prob=weight,replace=TRUE)
r = rnorm(n,mean=mu[z],sd=sigma[z])
return(r)
}
testcov<-0
for(i in 1:50){
 if(newz[i]==0){
   testcov[i]<-rnorm(1,mean=0,sd=1)
 }else{
  testcov[i]<-Simnorm(1)
 }
}
pvalue=pnorm(-testcov)
total1=Networks.Fast(pvalue,net,iter=5,nburns=2,
v=20,algorithms="DPM",
piall=c(0.8, 0.85, 0.9, 0.95),rhoall=c(1, 2, 5, 10, 15))
####checking accuracy
###checking accuracy of nodes
SummaryAccuracy(Trace=total1$trace,No.Sets=1,Type.Accuracy="Node",
True.Node=newz,Type.Net.Accuracy="Sample")
}
