% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{gower}
\alias{gower}
\title{Gower distance.}
\usage{
gower(trait, convert = NULL, weight = NULL)
}
\arguments{
\item{trait}{A species x traits matrix or data.frame.}

\item{convert}{A vector of column numbers, usually categorical variables, to be converted to dummy variables.}

\item{weight}{A vector of column numbers with weights for each variable. Its length must be equal to the number of columns in trait.}
}
\value{
A dist object with pairwise distances between species.
}
\description{
Calculates Gower distances between observations.
}
\details{
The Gower distance allows continuous, ordinal, categorical or binary variables, with possible weighting (Pavoine et al. 2009).
NAs are allowed as long as each pair of species has at least one trait value in common.
If convert is given the algorithm will convert these column numbers to dummy variables. Otherwise it will convert all columns with factors or characters as values.
}
\examples{
trait = data.frame(body = c(NA,2,3,4,4), beak = c(1,1,1,1,2))
gower(trait)
gower(trait, weight = c(1, 0))
}
\references{
Pavoine et al. (2009) On the challenge of treating various types of variables: application for improving the measurement of functional diversity. Oikos, 118: 391-402.
}
