% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bcdag.R
\name{plot.bcdag}
\alias{plot.bcdag}
\title{bcdag object plot}
\usage{
\method{plot}{bcdag}(x, ..., ask = TRUE)
}
\arguments{
\item{x}{a \code{bcdag} object for which a plot is desired}

\item{...}{additional arguments affecting the summary produced}

\item{ask}{Boolean argument passed to par() for visualization;}
}
\value{
Plot of the Median Probability DAG, a heatmap of the probabilities of edge inclusion and an histogram of the sizes of graphs visited by learn_DAG().
}
\description{
This method returns summary plots of the output of \code{learn_DAG()}.
}
\examples{
n <- 1000
q <- 4
DAG <- matrix(c(0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0), nrow = q)

L <- DAG
L[L != 0] <- runif(q, 0.2, 1)
diag(L) <- c(1,1,1,1)
D <- diag(1, q)
Sigma <- t(solve(L))\%*\%D\%*\%solve(L)

a <- 6
g <- 1/1000
U <- g*diag(1,q)
w = 0.2

set.seed(1)
X <- mvtnorm::rmvnorm(n, sigma = Sigma)

out <- learn_DAG(1000, 0, X, a, U, w, fast = TRUE, collapse = TRUE, save.memory = FALSE)
plot(out)
}
