% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BCT}
\alias{BCT}
\title{Bayesian Context Trees (BCT) algorithm}
\usage{
BCT(input_data, depth, beta = NULL)
}
\arguments{
\item{input_data}{the sequence to be analysed. 
The sequence needs to be a "character" object. See the examples section on how to transform any dataset to a "character" object.}

\item{depth}{maximum memory length.}

\item{beta}{hyper-parameter of the model prior. 
Takes values between 0 and 1. If not initialised in the call function, the default value is \ifelse{html}{\out{1-2<sup>-m+1</sup>}}{\eqn{1 - 2^{-m+1}}}, 
where \ifelse{html}{\out{m}}{\eqn{m}} is the size of the alphabet; for more information see \href{https://arxiv.org/pdf/2007.14900.pdf}{Kontoyiannis et al. (2020)}.}
}
\value{
returns a list object which includes:
\item{Contexts}{MAP model given as a list object containing the contexts of its leaves.}
\item{Results}{a dataframe with the following columns: prior probability, log(prior probability), posterior probability, log(posterior probability), number of leaves, maximum depth, BIC score, AIC score and maximum log-likelihood. }
}
\description{
Finds the maximum a posteriori probability (MAP) tree model.
}
\examples{
# Finding the MAP model with maximum depth <= 10 
# for the SP500 dataset (with default value beta):

BCT(SP500, 10)  

# For custom beta (e.g. 0.7):

BCT(SP500, 10, 0.7)  

# The type of the input dataset is "character"
# If the dataset is contained within a vector:

q <- c(1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0)

# Convert a vector to a "character" object:
s <- paste(q, collapse = "")

BCT(s, 2)

# Reading a file using the readChar function 

# Example 1: The dataset is stored in a .txt file

# fileName <- '~/example_data.txt' # fileName stores the path to the dataset

# s<-readChar(fileName, file.info(fileName)$size)

# Make sure that s does not contain any "\n" at the end of the string
# To remove last entry:
# s<-gsub('.$', '', s)

# To remove any unwanted characters (e.g. "\n"):
# s<-gsub('\n', '', s)

# Example 2: The dataset is stored in a .csv file

# fileName <- '~/example_data.csv' # fileName stores the path to the dataset

# s<-readChar(fileName, file.info(fileName)$size)

# Depending on the running environment, 
# s might contain unwanted characters such as: "\n" or "\r\n".
# Remove any unwanted characters (e.g. "\r\n"):
# s<-gsub('\r\n', '', s)

# Always make sure that s does not contain any unwanted characters
}
\seealso{
\code{\link{kBCT}}
}
