% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.test.R
\name{grnn.test}
\alias{grnn.test}
\title{Test a set of General Regression Neural Networks}
\usage{
grnn.test(results, test.set)
}
\arguments{
\item{results}{The object returned by \link[BETS]{grnn.train}.}

\item{test.set}{A \code{ts list}. The first element must be the actual values of the dependent variable. The others, the new values of the regressors.}
}
\value{
A \code{list} object representing the best network (according to forecasting MAPE). Its fields are:

\itemize{
\item{\code{mape}: The forecasting MAPE }
\item{\code{model}: The network object}
\item{\code{sigma}: The sigma parameter}
\item{\code{id}: The id number of the network, as given by \link[BETS]{grnn.train}}
\item{\code{mean}: The predicted values }
\item{\code{x}: The original series } 
\item{\code{fitted}: The fitted values }
\item{\code{actual}: The actual values (to be compared with the predicted values)}
\item{\code{residuals}: Difference between the fitted values and the series original values }
\item{\code{regressors}: The regressors used to train the network }
}
}
\description{
Given new values of the independent variables, tests a list of trained GRNNs and picks the best net, based on an accuracy measure between the forecasted and the actual values.
}
\author{
Talitha Speranza \email{talitha.speranza@fgv.br}
}
