% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.ggm_compare_estimate.R
\name{select.ggm_compare_estimate}
\alias{select.ggm_compare_estimate}
\title{Edge Differences and (Practical) Equivalence Between GGMs}
\usage{
\method{select}{ggm_compare_estimate}(object, cred = 0.95, rope = NULL, prob = 0.95, ...)
}
\arguments{
\item{object}{object of class \code{ggm_compare_estimate}}

\item{cred}{credible interval width used for the decision rule}

\item{rope}{region of practical equivalence}

\item{prob}{posterior probability (see notes)}

\item{...}{not currently used}
}
\value{
A list of class \code{select.ggm_compare_estimate}:
\code{rope} = NULL:
\itemize{
\item \code{mat_adj} adjacency matrix (one for each contrast)
\item \code{mat_pcor} selected partial correlations (one for each contrast)
\item \code{call} \code{match.call()}
\item \code{object} object of class \code{ggm_compare_estimate}
\item \code{rope} region of practical equivalence
\item \code{cred} credible interval
\item \code{prob} posterior probability
}
}
\description{
Edge Differences and (Practical) Equivalence Between GGMs
}
\note{
\code{prob} (posterior probability) is the decision rule for the rope. For example, with \code{rope = 0.1}
and \code{prob = 0.95}, differences require that 95 \% of the posterior exlcudes +- 0.1,
whereas equivalence requires that 95 \% of the posterior is within  +- 0.1.
}
\examples{
# data
Y1 <- BGGM::bfi[1:500,1:5]
Y2 <- BGGM::bfi[501:1000, 1:5]

# fit model
fit <- ggm_compare_estimate(Y1, Y2)

# posterior summary of differences
summary(fit)

# select (threshold) with credible intervals
sel <- select(fit)

# summary
summary(sel)

# selected differences
sel$mat_pcor

# adjacency matrix
sel$mat_adj
}
