% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{depression_anxiety_t1}
\alias{depression_anxiety_t1}
\title{Data: Depression and Anxiety (Time 1)}
\format{
A data frame containing 403 observations (n = 7466) and 16 variables (p = 16) measured on the 4-point
likert scale.
}
\usage{
data("depression_anxiety_t1")
}
\description{
A data frame containing 403 observations (n = 403) and 16 variables (p = 16) measured on the 4-point
likert scale (depression: 9; anxiety: 7).
}
\details{
\strong{Depression}:

\itemize{
  \item \code{PHQ1}  Little interest or pleasure in doing things?
  \item \code{PHQ2}  Feeling down, depressed, or hopeless?
  \item \code{PHQ3}  Trouble falling or staying asleep, or sleeping too much?
  \item \code{PHQ4}  Feeling tired or having little energy?
  \item \code{PHQ5}  Poor appetite or overeating?
  \item \code{PHQ6} Feeling bad about yourself — or that you are a failure or have let
                    yourself or your family down?
  \item \code{PHQ7}  Trouble concentrating on things, such as reading the newspaper or
                     watching television?
  \item \code{PHQ8} Moving or speaking so slowly that other people could have noticed? Or so
                    fidgety or restless that you have been moving a lot more than usual?
  \item \code{PHQ9}  Thoughts that you would be better off dead, or thoughts of hurting yourself
                     in some way?
}

  \strong{Anxiety}
  \itemize{



  \item \code{GAD1} Feeling nervous, anxious, or on edge
  \item \code{GAD2} Not being able to stop or control worrying
  \item \code{GAD3} Worrying too much about different things
  \item \code{GAD4} Trouble relaxing
  \item \code{GAD5} Being so restless that it's hard to sit still
  \item \code{GAD6} Becoming easily annoyed or irritable
  \item \code{GAD7} Feeling afraid as if something awful might happen
}
}
\examples{
data("depression_anxiety_t1")
labels<- c("interest", "down", "sleep",
            "tired", "appetite", "selfest",
           "concen", "psychmtr", "suicid",
           "nervous", "unctrworry", "worrylot",
           "relax", "restless", "irritable", "awful")


}
\references{
Forbes, M. K., Baillie, A. J., & Schniering, C. A. (2016). A structural equation modeling
analysis of the relationships between depression,anxiety, and sexual problems over time.
The Journal of Sex Research, 53(8), 942-954.

Forbes, M. K., Wright, A. G., Markon, K. E., & Krueger, R. F. (2019). Quantifying the reliability and replicability of psychopathology network characteristics.
Multivariate behavioral research, 1-19.

Jones, P. J., Williams, D. R., & McNally, R. J. (2019). Sampling variability is not nonreplication:
a Bayesian reanalysis of Forbes, Wright, Markon, & Krueger.
}
\keyword{datasets}
