% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSBPlotDiag.R
\name{BSBPlotDiag}
\alias{BSBPlotDiag}
\title{Plot diagnostics for BSBHaz model}
\usage{
BSBPlotDiag(
  bsbhaz,
  variable = c("omega1", "omega2", "lambda1", "lambda2", "gamma", "theta"),
  type = c("traceplot", "ergodic_means")
)
}
\arguments{
\item{bsbhaz}{An object of class 'BSBHaz' created by
\code{\link{BSBHaz}}.}

\item{variable}{A character indicating which variable to get the plot from.}

\item{type}{A character indicating if the plot should be a traceplot or plot
the ergodic means.}
}
\description{
Plot diagnostics for BSBHaz model
}
\examples{
t1 <- survival::Surv(c(1, 2, 3))
t2 <- survival::Surv(c(1, 2, 3))

init <- BSBInit(t1 = t1, t2 = t2, seed = 0)
samples <- BSBHaz(init, iter = 10, omega_d = 2,
gamma_d = 10, seed = 10)

BSBPlotDiag(samples, variable = "omega1", type = "traceplot")

}
