% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{DIC}
\alias{DIC}
\title{Deviance Information Criterion}
\usage{
DIC(object, ...)
}
\arguments{
\item{object}{an object of class \code{bgvar}.}

\item{...}{additional arguments.}
}
\value{
Returns a numeric value with the corresponding DIC.
}
\description{
Computes the Deviance information criterion for an object \code{bgvar}.
}
\examples{
\donttest{
library(BGVAR)
data(eerDatasmall)
model.mn <- bgvar(Data=eerDatasmall,W=W.trade0012.small,plag=2,draws=100,burnin=100,prior="MN")
DIC(model.mn)
}
}
\references{
Spiegelhalter, D. J. and Best, N. G., Carlin, B. P. and Linde, A. (2002) \emph{Bayesian measures of model complexity and fit.} Journal of the Royal Statistical Society, Series B, Vol. 64(4), pp. 583-639.
}
\author{
Maximilian Boeck
}
