% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{calculateRelatedness}
\alias{calculateRelatedness}
\title{Calculate Relatedness Coefficient}
\usage{
calculateRelatedness(
  generations = 2,
  path = NULL,
  full = TRUE,
  maternal = FALSE,
  empirical = FALSE,
  segregating = TRUE,
  total_a = 6800 * 1e+06,
  total_m = 16500,
  weight_a = 1,
  weight_m = 1,
  denom_m = FALSE,
  ...
)
}
\arguments{
\item{generations}{Number of generations back of common ancestors the pair share.}

\item{path}{Traditional method to count common ancestry, which is twice the number of generations removed from common ancestors. If not provided, it is calculated as 2*generations.}

\item{full}{Logical. Indicates if the kin share both parents at the common ancestor's generation. Default is TRUE.}

\item{maternal}{Logical. Indicates if the maternal lineage should be considered in the calculation.}

\item{empirical}{Logical. Adjusts the coefficient based on empirical data, using the total number of nucleotides and other parameters.}

\item{segregating}{Logical. Adjusts for segregating genes.}

\item{total_a}{Numeric. Represents the total size of the autosomal genome in terms of nucleotides, used in empirical adjustment. Default is 6800*1000000.}

\item{total_m}{Numeric. Represents the total size of the mitochondrial genome in terms of nucleotides, used in empirical adjustment. Default is 16500.}

\item{weight_a}{Numeric. Represents the weight of phenotypic influence from additive genetic variance, used in empirical adjustment.}

\item{weight_m}{Numeric. Represents the weight of phenotypic influence from mitochondrial effects, used in empirical adjustment.}

\item{denom_m}{Logical. Indicates if `total_m` and `weight_m` should be included in the denominator of the empirical adjustment calculation.}

\item{...}{Further named arguments that may be passed to another function.}
}
\value{
Relatedness Coefficient (`coef`): A measure of the genetic relationship between two individuals.
}
\description{
The relatedness coefficient between two people (b & c) is defined in relation to their common ancestors:
\eqn{r_{bc} = \sum \left(\frac{1}{2}\right)^{n+n'+1} (1+f_a)}
}
\details{
This function calculates the relatedness coefficient between two individuals based on their shared ancestry, as described by Wright (1922).
}
\examples{
\dontrun{
# For full siblings, the relatedness coefficient is expected to be 0.5:
calculateRelatedness(generations = 1, full = TRUE)
# For half siblings, the relatedness coefficient is expected to be 0.25:
calculateRelatedness(generations = 1, full = FALSE)
}
}
