% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_list_sf}
\alias{BIEN_list_sf}
\title{Extract a list of species within a given sf polygon.}
\usage{
BIEN_list_sf(sf, cultivated = FALSE, new.world = NULL, ...)
}
\arguments{
\item{sf}{An object of class ff.  Note that the object must be in WGS84.}

\item{cultivated}{Return information on cultivation status?  Default is FALSE.}

\item{new.world}{NULL (The default) returns global records, TRUE returns only New World, and FALSE only Old World.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing a list of all species with occurrences in the supplied sf object.
}
\description{
BIEN_list_sf produces a list of all species with occurrence records falling within a user-supplied sf object.
}
\examples{
\dontrun{
library(sf)

BIEN_ranges_species("Carnegiea gigantea") # saves ranges to the current working directory

sf <- st_read(dsn = ".",
              layer = "Carnegiea_gigantea")

species_list <- BIEN_list_sf(sf = sf)
}
}
\seealso{
Other list functions: 
\code{\link{BIEN_list_all}()},
\code{\link{BIEN_list_country}()},
\code{\link{BIEN_list_county}()},
\code{\link{BIEN_list_state}()}
}
\concept{list functions}
