% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{simulate_spatiotemporal_data}
\alias{simulate_spatiotemporal_data}
\title{Simulate Spatiotemporal Data Using Kernel Covariances.}
\usage{
simulate_spatiotemporal_data(
  nb_locations,
  nb_time_points,
  nb_spatial_dimensions,
  spatial_scale,
  time_scale,
  spatial_covariates_means,
  temporal_covariates_means,
  spatial_kernel,
  temporal_kernel,
  noise_variance_scale
)
}
\arguments{
\item{nb_locations}{Integer: Number of spatial locations}

\item{nb_time_points}{Integer: Number of time points}

\item{nb_spatial_dimensions}{Integer: Number of spatial dimensions}

\item{spatial_scale}{Numeric: Spatial scale}

\item{time_scale}{Numeric: Time scale}

\item{spatial_covariates_means}{Vector: Spatial covariates means}

\item{temporal_covariates_means}{Vector: Temporal covariates means}

\item{spatial_kernel}{Kernel: Spatial kernel}

\item{temporal_kernel}{Kernel: Temporal kernel}

\item{noise_variance_scale}{Numeric: Noise variance scale}
}
\value{
A list containing 4 dataframes:
     - `data_df` contains the response variable and the covariates
     - `spatial_positions_df` contains the spatial locations and their coordinates
     - `temporal_positions_df` contains the time points and their coordinates
     - `beta_df` contains the true beta coefficients
}
\description{
Simulate Spatiotemporal Data Using Kernel Covariances.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Simulate data with 20 locations, 30 time points, in 2D spatial dimensions
# with 3 spatial covariates and 2 temporal covariates
simu_data <- simulate_spatiotemporal_data(
   nb_locations=20,
   nb_time_points=30,
   nb_spatial_dimensions=2,
   spatial_scale=10,
   time_scale=10,
   spatial_covariates_means=c(0, 2, 4),
   temporal_covariates_means=c(1, 3),
   spatial_kernel=KernelMatern$new(),
   temporal_kernel=KernelSE$new(),
   noise_variance_scale=1)

# The dataframes are similar to bixi_data, we have:
# - data_df
head(simu_data$data_df)
# - spatial_positions_df
head(simu_data$spatial_positions_df)
# - temporal_positions_df
head(simu_data$temporal_positions_df)

# We also obtain the true beta coefficients used to simulate the data
head(simu_data$beta_df)
\dontshow{\}) # examplesIf}
}
