% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.R
\name{projection_posterior}
\alias{projection_posterior}
\title{Projection of Full-Posterior Draws onto a Reduced-Subset Model}
\usage{
projection_posterior(X_arr, beta1_arr, sigma1_vec, xs_vec, alpha1_arr = NULL)
}
\arguments{
\item{X_arr}{A 3-D array of predictors, of dimension \code{D * n * p}.}

\item{beta1_arr}{A \code{npost * D * p} array of full-model coefficient draws.}

\item{sigma1_vec}{Numeric vector of length \code{npost}, full-model residual variances.}

\item{xs_vec}{Logical vector of length \code{p}; \code{TRUE} indicates predictors to keep.}

\item{alpha1_arr}{Optional \code{npost * D} matrix of full_model intercept draws.
If \code{NULL} (the default), the projection omits an intercept term.}
}
\value{
A list with components:
\describe{
\item{\code{beta2_arr}}{Array \code{npost * D * p} of projected submodel coefficients.}
\item{\code{alpha2_arr}}{(If \code{alpha1_arr} provided) matrix \code{npost * D} of projected intercepts.}
\item{\code{sigma2_opt}}{Numeric vector length \code{npost} of projected residual variances.}
}
}
\description{
Given posterior draws \code{beta1_arr} (and optional intercepts \code{alpha1_arr})
from a full model fitted on \code{D} imputed datasets, compute
the predictive projection of each draw onto the submodel defined by \code{xs_vec}.
Returns the projected coefficients (and intercepts, if requested) plus the projected
residual variance for each posterior draw.
}
\examples{
D <- 3; n <- 50; p <- 5; npost <- 100
X_arr      <- array(rnorm(D*n*p), c(D, n, p))
beta1_arr  <- array(rnorm(npost*D*p), c(npost, D, p))
sigma1_vec <- runif(npost, 0.5, 2)
xs_vec     <- c(TRUE, FALSE, TRUE, FALSE, TRUE)
# Without intercept
proj <- projection_posterior(X_arr, beta1_arr, sigma1_vec, xs_vec)
str(proj)
# With intercept draws
alpha1_arr <- matrix(rnorm(npost*D), nrow = npost, ncol = D)
proj2 <- projection_posterior(X_arr, beta1_arr, sigma1_vec, xs_vec, alpha1_arr)
str(proj2)
}
