% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot_results.R
\name{summary.BMRMM}
\alias{summary.BMRMM}
\title{Summary Method for Objects of Class \code{BMRMM}}
\usage{
\method{summary}{BMRMM}(object, delta = 0.02, digits = 2, ...)
}
\arguments{
\item{object}{an object of class \code{BMRMM}.}

\item{delta}{threshold for the null hypothesis for the local tests of transition probabilities (see Details). Default is 0.02.}

\item{digits}{integer used for number formatting. Default is 2.}

\item{...}{further arguments for the summary function.}
}
\value{
An object of class \code{BMRMMsummary} with the following elements: \tabular{ll}{
\code{trans.global} \tab global test results for transition probabilities (see Details). \cr
\code{trans.probs.mean} \tab mean for the posterior transition probabilities. \cr
\code{trans.probs.sd} \tab standard deviation for the posterior transition probabilities. \cr
\code{trans.local.mean.diff} \tab the absolute difference in transition probabilities for a pair of covariate levels (see Details). \cr
\code{trans.local.null.test} \tab probability for the null hypothesis that the difference between two covariate levels is not significant (see Details). \cr
\code{dur.global} \tab global test results for duration times (see Details). \cr
\code{dur.mix.params} \tab mixture parameters taken from the last MCMC iteration if duration times follow a mixture gamma distribution. \cr
\code{dur.mix.probs}\tab mixture probabilities for each covariate taken from the last MCMC iteration if duration times follow a mixture gamma distribution. \cr
}
}
\description{
Summarizing an object of class \code{BMRMM}, including results for transition probabilities and duration times, if applicable.
}
\details{
We give more explanation for the global tests and local tests results.
\itemize{
\item{Global tests (for both transition probabilities and duration times)}

{Global tests are presented as a matrix, where the row denote the number of clusters and the column represents covariates.
For each row \code{i} and column \code{j}, the matrix entry is the percentage of the number of the clusters within the stored MCMC samples
for this covariate, i.e., an estimation for \verb{Pr(# clusters for covariate j == i)}. We note that the probability
\verb{Pr(# clusters for covariate j > 1)} would be the probability for the null hypothesis that the covariate \code{j} is significant.}
\item{Local tests (for transition probabilities only)}

{Local tests focus on a particular covariate and compare the influence among its levels when the other covariates values are fixed. \cr
Given a pair of levels of covariate \code{j}, say \code{j_1} and \code{j_2}, and given the levels of other covariates,
the null hypothesis is that the difference between \code{j_1} and \code{j_2} is not significant for transition probabilities.
It is calculated as the percentage of the samples with absolute difference less than \code{delta}.

The local tests provide two matrices of size \code{d0} x \code{d0} where \code{d0} is the number of states: \cr
\enumerate{
\item \code{mean.diff} -- the mean of the absolute difference in each transition type between levels \code{j_1} and \code{j_2};
\item \code{null.test} -- the probability of the null hypothesis that \code{j_1} and \code{j_2} have the same significance for each transition type.
}}
}
}
\examples{
results <- BMRMM(foxp2sm, num.cov = 2, simsize = 50, 
                 cov.labels = list(c("F", "W"), c("U", "L", "A")),
                 duration.distr = list('mixgamma',shape=rep(1,3),rate=rep(1,3)))
sm <- summary(results)
sm

}
\seealso{
\link{plot.BMRMMsummary} for plotting the summary results.
}
