% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmhyb.r
\name{SimulateNetwork}
\alias{SimulateNetwork}
\title{Simulate a phylogenetic network}
\usage{
SimulateNetwork(ntax = 100, nhybridizations = 10, birth = 1,
  death = 1, sample.f = 0.5, tree.height = 1, allow.ghost = FALSE,
  phy.graph = NULL, phy = NULL)
}
\arguments{
\item{ntax}{How many surviving taxa to have on the tree (extinct taxa are pruned, with the exception of donors if allow.ghost=TRUE)}

\item{nhybridizations}{How many hybridization events to have}

\item{birth}{Birth rate (instantaneous rate)}

\item{death}{Extinction rate (instantaneous)}

\item{sample.f}{What fraction of taxa alive at the present to sample (resulting in the final ntax)}

\item{tree.height}{Root to tip height of the final tree}

\item{allow.ghost}{Allow a hybridization events from an unsampled ancestor}

\item{phy.graph}{If not NULL, uses this network and adds hybridizations to it to reach nhybridizations in total}

\item{phy}{If not NULL, uses this tree to create hybridization events on}
}
\value{
A phy.graph object with hybridizations
}
\description{
This uses a birth death process (TreeSim::sim.bd.taxa.age) to make a tree, then randomly adds hybridization events. The events are placed uniformly with time (not with numbers of taxa). If you use the phy.graph argument, you can pass in an existing phylogenetic network and it will add hybridization events to that; if you use a phy argument, it will add hybridization events to that. Note that currently there is no checking for multiple events between the same two branches. While hybridization events happen between taxa alive at the same instant of time, it is possible that the donor taxon later goes extinct with no descendants (other than the taxa of hybrid origin). These are basically ghost lineages, and this process (which then looks like gene flow going forward in time) is permitted if allow.ghost is TRUE.
}
\examples{
p <- SimulateNetwork(ntax=10 ,nhybridizations=2)
plot(p)
}
