% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMisc.R
\name{panel2cs2}
\alias{panel2cs2}
\title{Panel Data to Repeated Cross Sections}
\usage{
panel2cs2(data, yname, idname, tname, balance_panel = TRUE)
}
\arguments{
\item{data}{data.frame used in function}

\item{yname}{name of outcome variable that can change over time}

\item{idname}{unique id}

\item{tname}{time period name}

\item{balance_panel}{whether to ensure that panel is balanced.  Default is TRUE, but code runs somewhat
faster if this is set to be FALSE.}
}
\value{
data from first period with .y0 (outcome in first period),
 .y1 (outcome in second period), and .dy (change in outcomes
 over time) appended to it
}
\description{
panel2cs2 takes a 2 period dataset and turns it
 into a cross sectional dataset; i.e., long to wide.
 This function considers a particular case where there is some outcome
 whose value can change over time.  It returns the dataset from the first
 period with the outcome in the second period and the change in outcomes
 over time appended to it
}
