% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get.oc.comb.phase12.R
\name{get.oc.comb.phase12}
\alias{get.oc.comb.phase12}
\title{Get the operating characteristics for phase I/II waterfall design}
\usage{
get.oc.comb.phase12(p.truetox, p.trueeff, target, eff.lb = 0.2, ncohort1,
  cohortsize1, n.earlystop = 10, ncohort2, cohortsize2, cutoff.eli = 0.95,
  cutoff.eff, p.saf = 0.6 * target, p.tox = 1.4 * target,
  extrasafe = FALSE, offset = 0.05, ntrial = 1000)
}
\arguments{
\item{p.truetox}{a \code{J*K} matrix \code{(J<=K)} containing the true toxicity probabilities of
combinations with \code{J} dose levels of agent A and \code{K} dose levels of agent B}

\item{p.trueeff}{a \code{J*K} matrix \code{(J<=K)} containing the true efficacy probability of
combinations with \code{J} dose levels of agent A and \code{K} dose levels of agent B}

\item{target}{the target toxicity rate}

\item{eff.lb}{the lower bound for efficacy}

\item{ncohort1}{a \code{1*J} vector specifying the number of cohorts for each of \code{J} subtrials
in phase I}

\item{cohortsize1}{the cohort size for phase I}

\item{n.earlystop}{the early stopping parameter for phase I. If the number of patients treated
at the current dose reaches \code{n.earlystop}, stop the trial and select the MTD based
on the observed data. The default value \code{n.earlystop=100} essentially turns off this
type of early stopping.}

\item{ncohort2}{the total number of cohorts for phase II}

\item{cohortsize2}{the cohort size for phase II}

\item{cutoff.eli}{the cutoff for dose elimination rule}

\item{cutoff.eff}{the cutoff for futility stopping}

\item{p.saf}{the highest toxicity probability that is deemed subtherapeutic (i.e. below the
MTD) such that dose escalation should be undertaken. The default value is
\code{p.saf=0.6*target}.}

\item{p.tox}{the lowest toxicity probability that is deemed overly toxic such that
deescalation is required. The default value is \code{p.tox=1.4*target}.}

\item{extrasafe}{set \code{extrasafe=TRUE} to impose a more stringent stopping rule}

\item{offset}{a small positive number (between 0 and 0.5) to control how strict the stopping
rule is when \code{extrasafe=TRUE}. A larger value leads to a more strict stopping
rule. The default value \code{offset=0.05} generally works well.}

\item{ntrial}{the total number of trials to be simulated}
}
\value{
This function returns the operating characteristics of the waterfall design as a list,
including (1) selection percentage at each dose level (\code{selpercent}), (2) the number of
patients treated at each dose (\code{npts}), (3) the number of toxicities observed at each
dose (\code{ntox}), (4) the number of efficacy/response observed at each dose (\code{neff})
(5) the total sample size (\code{totaln}).
}
\description{
Obtain the operating characteristics of phase I/II waterfall design, which aims to find
the optimal dose combination (ODC), defined as the combination that has the highest
efficacy among the doses in the MTD contour.
}
\details{
\code{get.oc.comb.phase12()} is consisted of two parts.
In the phase I part, the waterfall design is used to find the MTD contour
on the basis of only toxicity. Once the MTD contour is identified,
these MTDs are seamlessly moved to phase II to evaluate efficacy.
Each of the MTDs forms a treatment arm. Patients are eqally randomized into these arms to
evaluate efficacy. Toxicity and efficacy monitoring will be conducted after every
\code{cohortsize2} patients enrolled into each of treatment arms.
}
\examples{
p.truetox<-matrix(c(0.03,0.10,0.28, 0.10,0.30,0.50), nrow=2, byrow=TRUE)
p.trueeff<-matrix(c(0.20,0.30,0.50, 0.25,0.35,0.55), nrow=2, byrow=TRUE)
get.oc.comb.phase12(p.truetox, p.trueeff, target=0.30, eff.lb=0.2,
         ncohort1=c(12,8), cohortsize1=3, n.earlystop=12,
         ncohort2=12, cohortsize2=3, cutoff.eff =0.9, ntrial=10)
}
\author{
Suyu Liu and Ying Yuan
}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical
            Trials, Journal of the Royal Statistical Society: Series C, 64, 507-523.

           Lin R. and Yin, G. (2016). Bayesian Optimal Interval Designs for Dose Finding in
           Drug-combination Trials, Statistical Methods in Medical Research, to appear.

           Zhang L. and Yuan, Y. (2016). A Simple Bayesian Design to Identify the Maximum
           Tolerated Dose Contour for Drug Combination Trials, under review.
}
\seealso{
Tutorial: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/BOIN2.4_tutorial.pdf}

          Paper: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/paper.pdf}
}

