% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codes.R
\name{BP}
\alias{BP}
\alias{dBP}
\alias{pBP}
\alias{qBP}
\alias{rBP}
\alias{hBP}
\alias{plotBP}
\alias{meanBP}
\title{Reparameterized Beta Prime (BP) distribution for fitting a GAMLSS}
\usage{
BP(mu.link = "log", sigma.link = "log")

dBP(x, mu = 1, sigma = 1, log = FALSE)

pBP(q, mu = 1, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rBP(n = 1, mu = 1, sigma = 1)

qBP(p, mu = 1, sigma = 1, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{mu.link}{object for which the extraction of model residuals is
meaningful.}

\item{sigma.link}{type of residual to be used.}

\item{x, q}{vector of quantiles.}

\item{mu}{vector of scale parameter values.}

\item{sigma}{vector of shape parameter values.}

\item{log}{logical; if TRUE, quantiles are given as log.}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x],
otherwise, P[X > x].}

\item{log.p}{log.p logical; if TRUE, probabilities p are given as log(p).}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}

\item{p}{vector of probabilities.}
}
\value{
returns a \code{gamlss.family} object which can be used to fit a BP
distribution in the \code{gamlss()} function.
}
\description{
The function \code{BP()} defines the BP distribution, a two
parameter distribution, for a gamlss.family object to be used in GAMLSS
fitting using using the function \code{gamlss()}, with mean equal to the
parameter \code{mu} and \code{sigma} equal the precision parameter. The
functions \code{dBP}, \code{pBP}, \code{qBP} and \code{rBP} define the density
, distribution function, quantile function and random generation for the
\code{BP} parameterization of the BP distribution.
}
\note{
For the function BP(), mu is the mean and sigma is the precision
parameter of the BP distribution.
}
\examples{
y <- rBP(n = 100)
hist(y)
plot(function(x) dBP(x), 0.0001, 8)
gamlss::gamlss(y ~ 1, family = BP)
}
\references{
Rigby, R.A., Stasinopoulos, D.M., Heller, G.Z., and De Bastiani, F.
Distributions for modeling location, scale, and shape: Using GAMLSS in R,
London: Chapman and Hall/CRC, 2019.

Stasinopoulos D.M., Rigby R.A., Heller G., Voudouris V., and De Bastiani F.
Flexible Regression and Smoothing: Using GAMLSS in R, London:
Chapman and Hall/CRC, 2017

Bourguignon, M., Santos-Neto, M. and Castro, M. A new regression model for
positive random variables with skewed and long tail. \emph{METRON}, v. 79, p.
33--55, 2021. \doi{http://dx.doi.org/10.1007/s40300-021-00203-y}
}
\author{
Manoel Santos-Neto \email{manoel.ferreira at professor.ufcg.edu.br}
}
