% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Fitness}
\alias{Fitness}
\title{Number of sit-ups before and after a physical fitness course}
\format{A data frame/tibble with 18 observations on the three variables
\describe{ 
\item{subject}{a character variable indicating subject number}
\item{test}{a character variable with values \code{After} and \code{Before}} 
\item{number}{a numeric vector recording the number of sit-ups performed in one minute} 
}}
\usage{
Fitness
}
\description{
Data for Exercise 7.71
}
\examples{

t.test(number ~ test, data = Fitness, alternative = "greater", paired = TRUE)
\dontrun{
Wide <- tidyr::spread(Fitness, test, number) \%>\%
mutate(diff = After - Before)
Wide
qqnorm(Wide$diff)
qqline(Wide$diff)
t.test(Wide$diff, alternative = "greater")
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
