% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Fluid}
\alias{Fluid}
\title{Breakdown times of an insulating fluid under various levels of voltage
stress}
\format{A data frame/tibble with 76 observations on two variables
\describe{ 
\item{kilovolts}{a character variable showing kilowats} 
\item{time}{breakdown time (in minutes)} 
}}
\source{
E. Soofi, N. Ebrahimi, and M. Habibullah, 1995.
}
\usage{
Fluid
}
\description{
Data for Exercise 5.76
}
\examples{

DF1 <- Fluid[Fluid$kilovolts == "34kV", ]
DF1
# OR
DF2 <- subset(Fluid, subset = kilovolts == "34kV")
DF2
stem(DF2$time)
SIGN.test(DF2$time)
\dontrun{
library(dplyr)
DF3 <- dplyr::filter(Fluid, kilovolts == "34kV") 
DF3
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
