% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Magnesiu}
\alias{Magnesiu}
\title{Magnesium concentration and distances between samples}
\format{A data frame/tibble with 20 observations on two variables
\describe{ 
\item{distance}{distance between samples}
\item{magnesium}{concentration of magnesium} 
}}
\source{
Davis, J. (1986), \emph{Statistics and Data Analysis in Geology}, 2d. Ed.,
John Wiley and Sons, New York, p. 146.
}
\usage{
Magnesiu
}
\description{
Data for Exercise 9.9
}
\examples{

plot(magnesium ~ distance, data = Magnesiu)
model = lm(magnesium ~ distance, data = Magnesiu)
abline(model, col = "red")
summary(model)
rm(model)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
