% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sliceGammaMean.R
\name{sliceGammaMean}
\alias{sliceGammaMean}
\title{Generate a random sample of gamma for the R-BSL-M method of
\insertCite{Frazier2019;textual}{BSL} using slice sampling}
\usage{
sliceGammaMean(
  ssy,
  ssx,
  loglike,
  gamma = numeric(length(ssy)),
  tau = 1,
  w = 1,
  std = NULL,
  maxit = 1000
)
}
\arguments{
\item{ssy}{The observed summary statisic.}

\item{ssx}{A matrix of the simulated summary statistics. The number
of rows is the same as the number of simulations per iteration.}

\item{loglike}{The current log synthetic likelihood. This is computed with
function \code{\link{synLikeMisspec}} with the current gamma value.}

\item{gamma}{The additional latent parameter to account for possible
 incompatability between the model and observed summary statistic. In
 ``BSLmisspec'' method, this is updated with a slice sampler
 \insertCite{Neal2003}{BSL}. The default gamma implies no model misspecification
and is equivalent to the standard \code{\link{gaussianSynLike}} estimator.}

\item{tau}{Scale (or inverse rate) parameter of the Laplace prior
distribution for gamma.}

\item{w}{Step size for the stepping out in the slice sampler. The default
step size is 1.}

\item{std}{Standard deviation of the columns of ssx. If this is not
\code{NULL}, it will be used to save computation effort.}

\item{maxit}{The maximum number of iteration of the stepping out and shrink
steps of slice sampler. The default is 1e3.}
}
\description{
This function updates the gamma of the R-BSL-M method of
  \insertCite{Frazier2019;textual}{BSL} with a slice sampler
  \insertCite{Neal2003}{BSL}. Note this function is mainly designed for
  internal usage.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{sliceGammaVariance}} for the slice sampler of the
  variance inflated target distribution.
}
\keyword{internal}
