#include <R_ext/RS.double * h>
#include <stdlib.double * h> // for NULL
#include <R_ext/Rdynload.double * h>

/* FIXME: 
   Check these declarations against the C/Fortran source code.
*/

/* --------------------------- */
/* .Fortran calls */
/* --------------------------- */
extern void F77_NAME(linkr)(int * link, double * a, double * ylim, int * n, int * ilk, double * y, int * lk, double * gy, int * dl, double * dlink);

/* Simulating time series */
extern void F77_NAME(simbarcr)(int * n, int * burn, double * nu, double * alpha, int * nreg, double * beta, int * p, double * phi, int * r, double * theta, double * u0, int * map, int * link, double * ah, double * xreg, int * xregar, double * yt, double * ystart, double * xstart, double * mu, double * eta,  double * error, int * escale, double * Ts, int * ns, int * seed, int * rngtype, int * rev);
extern void F77_NAME(simbarfimaR)(int * n, int * burn, double * nu, double * alpha, int * nreg, double * beta, int * p, double * phi, int * q, double * theta, double * d, int * linkg, double * xreg, int * xregar, double * yt, double * ystart, double * xstart, double * mu, double * eta, double * error, int * escale, int * ns, int * seed, int * rngtype, int * inf, int * rev);
extern void F77_NAME(simkarfimaR)(int * n, int * burn, double * nu, double * alpha, int * nreg, double * beta, int * p, double * phi, int * q, double * theta, double * d, int * linkg, double * xreg, int * xregar, double * yt, double * ystart, double * xstart, double * mu, double * eta, double * error, int * escale, int * ns, int * seed, int * rngtype, int * inf, int * rev);
extern void F77_NAME(simgarfimaR)(int * n, int * burn, double * nu, double * alpha, int * nreg, double * beta, int * p, double * phi, int * q, double * theta, double * d, int * linkg, double * xreg, int * xregar, double * yt, double * ystart, double * xstart, double * mu, double * eta, double * error, int * escale, int * ns, int * seed, int * rngtype, int * inf, int * rev);
extern void F77_NAME(simuwarfimaR)(int * n, int * burn, double * nu, double * alpha, int * nreg, double * beta, int * p, double * phi, int * q, double * theta, double * d, int * linkg, double * xreg, int * xregar, double * yt, double * ystart, double * xstart, double * mu, double * eta, double * error, int * escale, int * ns, int * seed, int * rngtype, int * inf, int * rev);

/* Extracting components */
extern void F77_NAME(barcr)(int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, double * Ts, int * nnew, double * xnew, double * ynew, double * Tnew, int * link, double * ah, int * map, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * r, int * fixt, int * flagst, double * thetaT, int * fixnu, double * nu, int * fixu0, double * u0, int * llk, double * sll, int * sco, double * U, int * info, double * K);
extern void F77_NAME(barfimaR)(int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar,  int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, int * llk, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h);
extern void F77_NAME(karfimaR)(int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar,  int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, int * llk, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h);
extern void F77_NAME(garfimaR)(int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar,  int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, int * llk, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h);
extern void F77_NAME(uwarfimaR)(int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar,  int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, int * llk, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h);

/* Fitting parameters */
extern void F77_NAME(optimnelderbarcR)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, double * Ts, int * nnew, double * xnew, double * ynew, double * Tnew, int * link, double * ah, int * map, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi,  int * xregar, int * r, int * fixt, int * flagst, double * thetaT, int * fixnu, double * nu, int * fixu0, double * u0, double * sll, int * sco, double * U, int * info, double * K, int * iprint, double * stopcr, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimlbfgsbbarcR)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, double * Ts, int * nnew, double * xnew, double * ynew, double * Tnew, int * link, double * ah, int * map, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi,  int * xregar, int * r, int * fixt, int * flagst, double * thetaT, int * fixnu, double * nu,  int * fixu0, double * u0, double * sll, double * U, int * info, double * K, int * iprint, double * factr, double * pgtol, int * maxit, int * neval, int * conv); 
extern void F77_NAME(optimnelderbarfimaR)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy,double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * stopcr, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimlbfgsbbarfimaR)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * factr, double * pgtol, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimnelderkarfimaR)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy,double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * stopcr, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimlbfgsbkarfimaR)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * factr, double * pgtol, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimneldergarfimaR)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy,double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * stopcr, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimlbfgsbgarfimaR)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * factr, double * pgtol, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimnelderuwarfimaR)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy,double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, int * sco, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * stopcr, int * maxit, int * neval, int * conv);
extern void F77_NAME(optimlbfgsbuwarfimaR)(int * npar, double * par, int * nbd, double * lower, double * upper, int * n, double * y, double * gy, double * ystart, int * nreg, double * xreg, double * xstart, double * mu, double * eta, double * error, int * escale, int * nnew, double * xnew, double * ynew, int * link, int * fixa, double * alpha, int * fixB, int * flagsb, double * beta, int * p, int * fixar, int * flagsar, double * phi, int * xregar, int * q, int * fixma, int * flagsma, double * theta, int * fixd, double * d, int * fixnu, double * nu, int * inf, int * m, double * sll, double * U, int * info, double * K, int * extra, double * Drho, double * T, double * E, double * h, int * iprint, double * factr, double * pgtol, int * maxit, int * neval, int * conv);

/* Prediction */
extern void F77_NAME(predictbarcr)(int * n, double * y, double * gy, int * nreg, double * xreg, int * escale, double * error, double * Ts, int * nnew, double * xnew, double * ynew, double * Tnew, int * link, double * ah, int * map, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * fvbeta, int * p, int * fixar, int * flagsar, double * fvar, int * xregar, int * r, int * fixt, int * flagst, double * fvT, int * fixnu, double * nu, int * fixu0, double * u0);
extern void F77_NAME(btsrpredictr)(int * n, double * y, double * ylower, double * yupper, double * gy, int * nreg, double * xreg, int * escale, double * error, int * nnew, double * xnew, double * ynew, int * link, int * npar, double * par, int * fixa, double * alpha, int * fixB, int * flagsb, double * fvbeta, int * p, int * fixar, int * flagsar, double * fvar, int * xregar, int * q, int * fixma, int * flagsma, double * fvma, int * fixd, double * d, int * fixnu, double * nu, int * inf);
/* --------------------------- */
/* end of .Fortran calls */
/* --------------------------- */ 

static const R_FortranMethodDef FortranEntries[] = {
    {"linkr",                (DL_FUNC) &F77_NAME(linkr),                10},
		{"simbarcr",             (DL_FUNC) &F77_NAME(simbarcr),             28},
		{"simbarfimaR",          (DL_FUNC) &F77_NAME(simbarfimaR),          26},
		{"simkarfimaR",          (DL_FUNC) &F77_NAME(simkarfimaR),          26},
		{"simgarfimaR",          (DL_FUNC) &F77_NAME(simgarfimaR),          26},
		{"simuwarfimaR",         (DL_FUNC) &F77_NAME(simuwarfimaR),         26},
		{"barcr",                (DL_FUNC) &F77_NAME(barcr),                45},
		{"barfimaR",             (DL_FUNC) &F77_NAME(barfimaR),             48},
		{"karfimaR",             (DL_FUNC) &F77_NAME(karfimaR),             48},
		{"garfimaR",             (DL_FUNC) &F77_NAME(garfimaR),             48},
		{"uwarfimaR"             (DL_FUNC) &F77_NAME(uwarfimaR),            48},
		{"optimnelderbarcr",     (DL_FUNC) &F77_NAME(optimnelderbarcr),     52},
		{"optimlbfgsbbarcr",     (DL_FUNC) &F77_NAME(optimlbfgsbbarcr),     52},    
		{"optimnelderbarfimaR",  (DL_FUNC) &F77_NAME(optimnelderbarfimaR),  55},
    {"optimlbfgsbbarfimaR",  (DL_FUNC) &F77_NAME(optimlbfgsbbarfimaR),  55},
		{"optimnelderkarfimaR",  (DL_FUNC) &F77_NAME(optimnelderkarfimaR),  55},
    {"optimlbfgsbkarfimaR",  (DL_FUNC) &F77_NAME(optimlbfgsbkarfimaR),  55},
    {"optimneldergarfimaR",  (DL_FUNC) &F77_NAME(optimneldergarfimaR),  55},
    {"optimlbfgsbgarfimaR",  (DL_FUNC) &F77_NAME(optimlbfgsbgarfimaR),  55},
    {"optimnelderuwarfimaR", (DL_FUNC) &F77_NAME(optimnelderuwarfimaR), 55},
    {"optimlbfgsbuwarfimaR", (DL_FUNC) &F77_NAME(optimlbfgsbuwarfimaR), 55},
    {"predictbarcr",         (DL_FUNC) &F77_NAME(predictbarcr),         35},
    {"btsrpredictr",         (DL_FUNC) &F77_NAME(btsrpredictr),         34},    
    {NULL, NULL, 0}
};

void R_init_BTSR(DllInfo *dll)
{
    R_registerRoutines(dll, NULL, NULL, FortranEntries, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
