% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult_3d.R
\name{mult_3d}
\alias{mult_3d}
\title{Multiply three matrices (or vectors) through a given core tensor to form a 
three dimensional tensor.}
\usage{
mult_3d(core, x, y, z, names = T)
}
\arguments{
\item{core}{array}

\item{x}{matrix to multiply by the first mode of \code{core}}

\item{y}{matrix to multiply by the second mode of \code{core}}

\item{z}{matrix to multiply by the third mode of \code{core}}

\item{names}{logical indicating whether to keep the dimension names}
}
\value{
Array with sizes given by the number of rows in x, y and z
}
\description{
The package 'rTensor' is required and the number of columns of x, y and z must 
match the dimensions of core.
}
\examples{
mult_3d(array(1:24, dim=c(2,3,4)), matrix(1:4,2,2), matrix(1:6,2,3), matrix(1:8,2,4))
}

