% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_input.R
\name{.validate_input}
\alias{.validate_input}
\title{.validate_input}
\usage{
.validate_input(
  N1 = NULL,
  Test = NULL,
  Nsimu1 = NULL,
  ffdc = NULL,
  covariates = NULL,
  r1 = NULL,
  delta = NULL,
  perVol = NULL,
  Min.vol = NULL,
  n0 = NULL,
  Cutpos1 = NULL,
  ffdGroup = NULL
)
}
\arguments{
\item{N1}{is the number of images (2<N1<T) from the ffdc array employed in the model fitting.N1=NULL (or equivalently N1=T) is its default value, taking all the images in the ffdc array for the fitting process.}

\item{Test}{test type either "LTT" (Average cluster effect) or "JointTest" (Joint effect).}

\item{Nsimu1}{is the number of simulated on-line trajectories related to the state parameters. These simulated curves are later employed to compute the posterior probability of voxel activation.}

\item{ffdc}{a 4D array (ffdc[i,j,k,t]) that contains the sequence of MRI images that are meant to be analyzed. (i,j,k) define the position of the observed voxel at time t.}

\item{covariates}{a data frame or matrix whose columns contain the covariates related to the expected BOLD response obtained from the experimental setup.}

\item{r1}{a positive integer number that defines the distance from every voxel with its most distant neighbor. This value determines the size of the cluster. The users can set a range of different r values: r = 0, 1, 2, 3, 4, which leads to q = 1, 7, 19, 27, 33, where q is the size of the cluster.}

\item{delta}{a discount factor related to the evolution variances. Recommended values between 0.85<delta<1. delta=1 will yield results similar to the classical general linear model.}

\item{perVol}{helps to define a threshold for the voxels considered in the analysis. For example, Min.vol = 0.10 means that all the voxels with values
below to max(ffdc)*perVol can be considered irrelevant and discarded from the analysis.}

\item{Min.vol}{helps to define a threshold for the voxels considered in
the analysis. For example, Min.vol = 0.10 means that all the voxels with values
below to max(ffdc)*Min.vol can be considered irrelevant and discarded from the analysis.}

\item{n0}{a positive hyperparameter of the prior distribution for the covariance matrix S0 at t=0 (n=1 is the default value when no prior information is available). For the case of available prior information, n0 can be set as n0=np, where np is the number of MRI images in the pilot sample.}

\item{Cutpos1}{a cutpoint time from where the on-line trajectories begin. This parameter value is related to an approximation from a t-student distribution to a normal distribution. Values equal to or greater than 30 are recommended (30<Cutpos1<T).}

\item{ffdGroup}{group}
}
\description{
validate input
}
\keyword{internal}
