% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f2pbs.R
\name{f2pbs}
\alias{f2pbs}
\title{Calculation of a parametric bootstrap 100*level\% confidence interval for the F2 parameter}
\usage{
f2pbs(
  dis_data,
  level = 0.9,
  B = 1000,
  ci.type = c("quantile", "HPD"),
  get.dist = FALSE
)
}
\arguments{
\item{dis_data}{A data frame containing the dissolution data. The first column of the data frame should denote
the group labels identifying whether a given dissolution belongs to the "reference" or "test" formulation group.
For a given dissolution run, the remaining columns of the data frame contains the individual run's dissolution
measurements sorted in time. Alternatively, the user may provide a data object of class dis_data containing the
dissolution data. See the \code{make_dis_data()} function for the particular structure of the data object.}

\item{level}{The confidence level. A value between 0 and 1.}

\item{B}{A positive integer specifying the number of bootstrap samples.}

\item{ci.type}{The type of confidence interval to report. Specifying \code{quantile} returns a bootstrap confidence interval based on the sample quantiles. Specifying \code{HPD} returns a highest density region interval.}

\item{get.dist}{logical; if \code{TRUE}, returns the posterior samples of the F2 distribution.}
}
\value{
The function returns a 100*level\% confidence interval for the F2 parameter calculated from the observed dissolution data.
}
\description{
This function calculates a 100*level\% confidence interval for the F2 parameter using a parametric bootstrap based on a two variance component model with means for Time x Group, i.e.,  Dissolution ~ Time x Group + (1|Tablet:Group).
}
\note{
Use the \code{plotdiss()} or \code{ggplotdiss()} function to visually check if it's appropriate to calculate the f2 statistic.
}
\examples{
### dis_data comes loaded with the package
f2pbs(dis_data, level = 0.9, B = 1000)

}
