% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfold_cv.R
\name{run_kfold_cv}
\alias{run_kfold_cv}
\title{Run k-fold cross-validation}
\usage{
run_kfold_cv(ermod, newdata = NULL, k = 5, seed = NULL)
}
\arguments{
\item{ermod}{An \code{ermod} object containing the model and data.}

\item{newdata}{Optional new dataset to use instead of the original data.
Default is NULL.}

\item{k}{The number of folds for cross-validation. Default is 5.}

\item{seed}{Random seed for reproducibility. Default is NULL.}
}
\value{
A \code{kfold_cv_ermod} class object containing the fitted models and
holdout predictions for each fold.
}
\description{
This function performs k-fold cross-validation using the appropriate model
development function based on the class of the \code{ermod} object.
}
\examples{
\donttest{
data(d_sim_binom_cov_hgly2)

ermod_bin <- dev_ermod_bin(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov = "BHBA1C_5",
  # Settings to make the example run faster
  chains = 2,
  iter = 1000
)

cv_results <- run_kfold_cv(ermod_bin, k = 3, seed = 123)

print(cv_results)
}

}
