% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_func.R
\name{GH_MGF}
\alias{GH_MGF}
\title{GH Moment Generating Function}
\usage{
GH_MGF(r, mu = 0, delta, alpha, lambda, beta = 0)
}
\arguments{
\item{r}{Coefficient of the MGF. Can be viewd also as the order of the log-GH moments.}

\item{mu}{Location parameter, default set to 0.}

\item{delta}{Concentration parameter, must be positive.}

\item{alpha}{Tail parameter, must be positive and greater than the modulus of \code{beta}.}

\item{lambda}{Shape parameter.}

\item{beta}{Skewness parameter, default set to 0 (symmetric case).}
}
\description{
Function that implements the moment generating function of the Generalized Hyperbolyc (GH) distribution.
}
\details{
This function allows to evaluate the moment generating function of the GH distribution in the point \code{r}.
It is defined only for points that are lower than the value of \eqn{\gamma}, that is defined as:
\eqn{\gamma^2=\alpha^2-\beta^2.}
For integer values of \code{r}, it could also be considered as the
\emph{r}-th raw moment of the log-GH distribution.
}
