% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LN_mean.R
\name{LN_Mean}
\alias{LN_Mean}
\title{Bayesian Estimate of the Log-normal Mean}
\source{
Fabrizi, E., & Trivisano, C. \emph{Bayesian estimation of log-normal means with finite quadratic expected loss}. Bayesian Analysis, 7(4), 975-996. (2012).
}
\usage{
LN_Mean(
  x,
  method = "weak_inf",
  x_transf = TRUE,
  CI = TRUE,
  alpha_CI = 0.05,
  type_CI = "two-sided",
  nrep = 1e+05
)
}
\arguments{
\item{x}{Vector containing the sample.}

\item{method}{String that indicates the prior setting to adopt. Choosing \code{"weak_inf"} a weakly informative prior setting is adopted, whereas selecting
\code{"optimal"} the hyperparameters are aimed at minimizing the frequentist MSE.}

\item{x_transf}{Logical. If \code{TRUE}, the \code{x} vector is assumed already log-transformed.}

\item{CI}{Logical. With the default choice \code{TRUE}, the posterior credibility interval is computed.}

\item{alpha_CI}{Level of alpha that determines the credibility (1-\code{alpha_CI}) of the posterior interval.}

\item{type_CI}{String that indicates the type of interval to compute: \code{"two-sided"} (default),
\code{"UCL"} (i.e. Upper Credible Limit) for upper one-sided intervals or \code{"LCL"} (i.e. Lower
Credible Limit) for lower one-sided intervals.}

\item{nrep}{Number of simulations for the computation of the credible intervals.}
}
\value{
The function returns a list which includes the prior and posterior parameters, the point estimate of the log-normal mean that consists in the mean of the posterior
distribution of the functional \eqn{\exp\{\mu+\sigma^2/2\}} and the posterior variance.
}
\description{
This function produces a Bayesian estimate of the log-normal mean, assuming a GIG prior for the variance and an
improper flat prior for the mean in the log scale.
}
\details{
Summarizing the posterior mean of the log-normal expectation might be delicate since several
common priors used for the variance do not produces posteriors with finite moments. The proposal by Fabrizi and Trivisano (2012) of adopting a generalized inverse Gaussian (GIG)
prior for the variance in the log scale \eqn{\sigma^2} has been implemented. Moreover, they discussed how to specify the hyperparameters according to two different aims.

Firstly, a weakly informative
prior allowed to produce posterior credible intervals with good frequentist properties, whereas a prior aimed at minimizing the point estimator
MSE was proposed too. The choice between the two priors can be made through the argument \code{method}.

The point estimates are exact values, whereas the credible intervals are provided through simulations from the posterior distribution.
}
\examples{
# Load data
data("NCBC")
# Optimal point estimator
LN_Mean(x = NCBC$al, x_transf = FALSE, method = "optimal", CI = FALSE)
# Weakly informative prior and interval estimation
LN_Mean(x = NCBC$al, x_transf = FALSE, type_CI = "UCL")

}
