library(parallel)
test_that("compute_mallows_mixtures works", {
  set.seed(1234)
  n_clusters <- c(1, 4, 6)
  models <- compute_mallows_mixtures(n_clusters = n_clusters,
                                     nmc = 20L,
                                     rankings = sushi_rankings[1:100, ])

  expect_equal(round(models[[1]]$alpha$value, 10),
               c(1, 0.9613263178, 0.9613263178, 0.8831344651, 0.9125035114,
                 0.9125035114, 0.8865988675, 0.8865988675, 0.8865988675, 0.8865988675,
                 0.8205473633, 0.8205473633, 0.6941503586, 0.767450906, 0.7817768491,
                 0.882383532, 0.9845249867, 0.9283154749, 1.1219871023, 1.0797258265
               ))

  expect_equal(models[[2]]$rho$value,
               c(7, 10, 2, 4, 3, 6, 9, 5, 1, 8, 7, 10, 2, 4, 3, 6, 9, 5, 1,
                 8, 7, 10, 2, 4, 3, 6, 9, 5, 1, 8, 7, 10, 2, 4, 3, 6, 9, 5, 1,
                 8, 7, 10, 2, 4, 3, 6, 9, 5, 1, 8, 7, 10, 2, 3, 5, 6, 9, 4, 1,
                 8, 7, 10, 2, 4, 3, 6, 9, 5, 1, 8, 7, 10, 2, 4, 3, 6, 9, 5, 1,
                 8, 7, 10, 2, 4, 3, 6, 9, 5, 1, 8, 7, 10, 2, 3, 5, 6, 8, 4, 1,
                 9, 7, 10, 2, 5, 4, 6, 9, 3, 1, 8, 6, 10, 2, 4, 3, 7, 9, 5, 1,
                 8, 7, 10, 1, 4, 3, 6, 9, 5, 2, 8, 7, 10, 2, 3, 5, 6, 8, 4, 1,
                 9, 7, 10, 2, 5, 4, 6, 9, 3, 1, 8, 6, 10, 2, 4, 3, 7, 9, 5, 1,
                 8, 8, 10, 1, 4, 3, 6, 9, 5, 2, 7, 5, 10, 2, 3, 6, 7, 8, 4, 1,
                 9, 6, 10, 2, 5, 4, 7, 9, 3, 1, 8, 6, 10, 3, 4, 2, 7, 9, 5, 1,
                 8, 8, 10, 1, 4, 3, 6, 9, 5, 2, 7, 5, 8, 2, 3, 6, 7, 9, 4, 1,
                 10, 6, 10, 2, 5, 4, 7, 9, 3, 1, 8, 6, 10, 2, 4, 3, 7, 9, 5, 1,
                 8, 8, 10, 1, 4, 3, 6, 9, 5, 2, 7, 5, 8, 2, 3, 6, 7, 9, 4, 1,
                 10, 5, 10, 2, 6, 4, 7, 9, 3, 1, 8, 6, 10, 2, 3, 5, 7, 9, 4, 1,
                 8, 10, 9, 1, 4, 3, 6, 8, 5, 2, 7, 5, 8, 2, 3, 6, 7, 9, 4, 1,
                 10, 5, 9, 2, 6, 4, 7, 10, 3, 1, 8, 7, 10, 2, 3, 5, 6, 9, 4, 1,
                 8, 10, 7, 1, 4, 3, 6, 9, 5, 2, 8, 5, 8, 1, 2, 6, 7, 9, 4, 3,
                 10, 5, 9, 4, 6, 3, 7, 10, 2, 1, 8, 8, 10, 2, 3, 5, 6, 7, 4, 1,
                 9, 10, 7, 1, 5, 3, 6, 9, 4, 2, 8, 5, 8, 1, 2, 6, 7, 9, 4, 3,
                 10, 5, 10, 4, 6, 3, 7, 9, 2, 1, 8, 9, 8, 2, 3, 5, 6, 7, 4, 1,
                 10, 8, 7, 1, 5, 3, 6, 10, 4, 2, 9, 5, 8, 1, 2, 6, 7, 9, 4, 3,
                 10, 4, 10, 5, 6, 3, 7, 9, 2, 1, 8, 9, 8, 2, 3, 6, 5, 7, 4, 1,
                 10, 8, 7, 2, 5, 3, 6, 10, 4, 1, 9, 5, 8, 1, 2, 6, 7, 9, 4, 3,
                 10, 4, 10, 5, 6, 3, 7, 9, 2, 1, 8, 10, 8, 2, 3, 6, 5, 7, 4, 1,
                 9, 8, 7, 2, 5, 3, 6, 10, 4, 1, 9, 5, 8, 1, 2, 6, 7, 9, 4, 3,
                 10, 4, 10, 5, 7, 3, 6, 9, 2, 1, 8, 10, 8, 1, 3, 6, 5, 7, 4, 2,
                 9, 8, 7, 1, 5, 2, 6, 10, 4, 3, 9, 5, 8, 1, 2, 6, 7, 9, 4, 3,
                 10, 4, 10, 5, 7, 2, 6, 9, 1, 3, 8, 10, 8, 1, 3, 6, 5, 7, 4, 2,
                 9, 8, 7, 1, 5, 2, 6, 9, 4, 3, 10, 5, 7, 1, 2, 6, 8, 9, 4, 3,
                 10, 4, 9, 5, 7, 2, 6, 10, 1, 3, 8, 10, 7, 1, 3, 6, 5, 8, 4, 2,
                 9, 7, 6, 1, 5, 2, 8, 9, 4, 3, 10, 5, 7, 1, 2, 6, 8, 9, 4, 3,
                 10, 4, 10, 5, 7, 2, 6, 9, 1, 3, 8, 10, 9, 1, 3, 6, 5, 7, 4, 2,
                 8, 7, 6, 1, 5, 3, 8, 9, 2, 4, 10, 5, 8, 1, 2, 6, 9, 7, 4, 3,
                 10, 4, 10, 5, 7, 2, 6, 9, 1, 3, 8, 10, 8, 1, 3, 6, 5, 7, 4, 2,
                 9, 7, 6, 2, 5, 3, 8, 9, 1, 4, 10, 5, 8, 1, 2, 6, 9, 7, 4, 3,
                 10, 4, 10, 5, 7, 2, 6, 9, 1, 3, 8, 10, 8, 1, 3, 6, 4, 7, 5, 2,
                 9, 7, 6, 2, 5, 3, 8, 9, 1, 4, 10, 5, 7, 1, 2, 6, 8, 9, 4, 3,
                 10, 4, 10, 5, 7, 2, 6, 9, 1, 3, 8, 10, 8, 2, 3, 6, 4, 7, 5, 1,
                 9, 7, 6, 1, 5, 2, 8, 9, 3, 4, 10, 5, 6, 1, 2, 8, 7, 9, 4, 3,
                 10, 4, 10, 5, 7, 2, 6, 9, 1, 3, 8, 10, 7, 2, 3, 6, 4, 8, 5, 1,
                 9))

  expect_equal(models[[3]]$rho_acceptance,
               structure(c(0.7, 0.85, 0.85, 0.9, 0.8, 0.75), .Dim = c(6L, 1L
               )))


  set.seed(123)
  mixture_model <- compute_mallows(rankings = sushi_rankings[1:100, ], n_clusters = 5,
                                   include_wcd = TRUE, save_clus = TRUE, nmc = 10)

  expect_equal(mixture_model$within_cluster_distance$value,
               c(632, 670, 700, 726, 568, 518, 812, 898, 640, 428, 416, 1114,
                 880, 466, 402, 410, 1230, 536, 604, 394, 468, 942, 668, 812,
                 294, 632, 1204, 610, 398, 278, 712, 936, 654, 454, 400, 474,
                 888, 942, 446, 308, 740, 748, 984, 304, 258, 770, 664, 1154,
                 180, 218))

  # check that it runs in parallel
  cl <- makeCluster(1)
  models <- compute_mallows_mixtures(n_clusters = n_clusters,
                                     nmc = 20L,
                                     rankings = sushi_rankings[1:100, ],
                                     cl = cl)
  stopCluster(cl)
  expect_s3_class(models, "BayesMallowsMixtures")

})
