% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.BayesMallows}
\alias{plot.BayesMallows}
\title{Plot Posterior Distributions}
\usage{
\method{plot}{BayesMallows}(x, burnin = x$burnin, parameter = "alpha", items = NULL, ...)
}
\arguments{
\item{x}{An object of type \code{BayesMallows}, returned from
\code{\link[=compute_mallows]{compute_mallows()}}.}

\item{burnin}{A numeric value specifying the number of iterations
to discard as burn-in. Defaults to \code{x$burnin}, and must be
provided if \code{x$burnin} does not exist. See \code{\link[=assess_convergence]{assess_convergence()}}.}

\item{parameter}{Character string defining the parameter to plot. Available
options are \code{"alpha"}, \code{"rho"}, \code{"cluster_probs"},
\code{"cluster_assignment"}, and \code{"theta"}.}

\item{items}{The items to study in the diagnostic plot for \code{rho}. Either
a vector of item names, corresponding to \code{x$items} or a
vector of indices. If NULL, five items are selected randomly.
Only used when \code{parameter = "rho"}.}

\item{...}{Other arguments passed to \code{plot} (not used).}
}
\description{
Plot posterior distributions of the parameters of the Mallows Rank model.
}
\examples{
model_fit <- compute_mallows(setup_rank_data(potato_visual))
model_fit$burnin <- 1000

# By default, the scale parameter "alpha" is plotted
plot(model_fit)
# We can also plot the latent rankings "rho"
plot(model_fit, parameter = "rho")
# By default, a random subset of 5 items are plotted
# Specify which items to plot in the items argument.
plot(model_fit, parameter = "rho",
     items = c(2, 4, 6, 9, 10, 20))
# When the ranking matrix has column names, we can also
# specify these in the items argument.
# In this case, we have the following names:
colnames(potato_visual)
# We can therefore get the same plot with the following call:
plot(model_fit, parameter = "rho",
     items = c("P2", "P4", "P6", "P9", "P10", "P20"))

\dontrun{
  # Plots of mixture parameters:
  model_fit <- compute_mallows(
    setup_rank_data(sushi_rankings),
    model_options = set_model_options(n_clusters = 5))
  model_fit$burnin <- 1000
  # Posterior distributions of the cluster probabilities
  plot(model_fit, parameter = "cluster_probs")
  # Cluster assignment plot. Color shows the probability of belonging to each
  # cluster.
  plot(model_fit, parameter = "cluster_assignment")
}




}
\seealso{
Other posterior quantities: 
\code{\link{assign_cluster}()},
\code{\link{compute_consensus}()},
\code{\link{compute_posterior_intervals}()},
\code{\link{heat_plot}()},
\code{\link{plot.SMCMallows}()},
\code{\link{plot_elbow}()},
\code{\link{plot_top_k}()},
\code{\link{predict_top_k}()},
\code{\link{print.BayesMallows}()}
}
\concept{posterior quantities}
