/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.wrightfisher;

import dr.evolution.datatype.GeneticCode;
import dr.evolution.wrightfisher.FitnessFunction;
import dr.evolution.wrightfisher.Genome;
import dr.evolution.wrightfisher.Mutation;
import dr.evolution.wrightfisher.Mutator;

public class SimpleGenome
implements Genome {
    byte[] sequence;
    double fitness;
    Mutation[] mutations = null;
    Genome parent;
    int marks = 0;

    public SimpleGenome(int n, FitnessFunction fitnessFunction, boolean bl) {
        this.sequence = new byte[n];
        if (bl) {
            fitnessFunction.initializeToFittest(this.sequence);
        }
        this.fitness = 1.0;
        this.parent = null;
    }

    private SimpleGenome(byte[] byArray, double d, Genome genome, Mutation[] mutationArray) {
        this.sequence = byArray;
        this.fitness = d;
        this.parent = genome;
        this.mutations = mutationArray;
    }

    @Override
    public Genome replicate(Mutator mutator, FitnessFunction fitnessFunction) {
        byte[] byArray = new byte[this.sequence.length];
        Mutation[] mutationArray = mutator.mutate(this.sequence, byArray);
        double d = fitnessFunction.getFitness(byArray);
        return new SimpleGenome(byArray, d, this, mutationArray);
    }

    @Override
    public byte[] getSequence() {
        return this.sequence;
    }

    @Override
    public int hammingDistance(Genome genome) {
        int n = 0;
        byte[] byArray = genome.getSequence();
        for (int i = 0; i < this.sequence.length; ++i) {
            if (this.sequence[i] == byArray[i]) continue;
            ++n;
        }
        return n;
    }

    @Override
    public String getDNASequenceString() {
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < this.sequence.length; ++i) {
            switch (this.sequence[i]) {
                case 0: {
                    stringBuffer.append('A');
                    continue block6;
                }
                case 1: {
                    stringBuffer.append('C');
                    continue block6;
                }
                case 2: {
                    stringBuffer.append('G');
                    continue block6;
                }
                case 3: {
                    stringBuffer.append('T');
                    continue block6;
                }
                default: {
                    stringBuffer.append('N');
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String getAminoAcidSequenceString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.sequence.length; i += 3) {
            int n = this.sequence[i] * 16 + this.sequence[i + 1] * 4 + this.sequence[i + 2];
            char c = GeneticCode.UNIVERSAL.getAminoAcidChar(n);
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    @Override
    public final void mark() {
        ++this.marks;
        if (this.parent != null) {
            this.parent.mark();
        }
    }

    @Override
    public final void unmark() {
        this.marks = 0;
        if (this.parent != null) {
            this.parent.unmark();
        }
    }

    @Override
    public final int getMarks() {
        return this.marks;
    }

    @Override
    public final Genome getParent() {
        return this.parent;
    }

    @Override
    public final double getFitness() {
        return this.fitness;
    }

    @Override
    public final Mutation[] getMutations() {
        return this.mutations;
    }

    @Override
    public final int getGenomeLength() {
        return this.sequence.length;
    }
}

