/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.statistics;

import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class KStatistic
extends Statistic.Abstract
implements VariableListener {
    public static final String K_STATISTIC = "kStatistic";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String INDICATORS = "indicators";
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("indicators", Parameter.class)};

        @Override
        public String getParserName() {
            return KStatistic.K_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(INDICATORS);
            return new KStatistic(parameter);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a statistic that shifts a matrix of locations by location drift in the first dimension.";
        }

        @Override
        public Class getReturnType() {
            return KStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private Parameter indicatorsParameter;

    public KStatistic(Parameter parameter) {
        this.indicatorsParameter = parameter;
        this.indicatorsParameter.addParameterListener(this);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        double d = 0.0;
        for (int i = 0; i < this.indicatorsParameter.getDimension(); ++i) {
            if ((int)this.indicatorsParameter.getParameterValue(i) != 1) continue;
            d += 1.0;
        }
        return d;
    }

    @Override
    public String getDimensionName(int n) {
        String string = "K";
        return string;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

