/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.basta;

import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.DataType;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.coalescent.basta.OldStructuredCoalescentLikelihood;
import dr.evomodel.coalescent.basta.StructuredCoalescentLikelihood;
import dr.evomodel.substmodel.GeneralSubstitutionModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class StructuredCoalescentLikelihoodParser
extends AbstractXMLObjectParser {
    public static final String STRUCTURED_COALESCENT = "structuredCoalescent";
    public static final String TYPE = "type";
    public static final String INCLUDE = "include";
    public static final String EXCLUDE = "exclude";
    public static final String SUBINTERVALS = "subIntervals";
    public static final String MAP_RECONSTRUCTION = "useMAP";
    public static final Boolean USE_OLD_CODE = false;
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("subIntervals", true), new ElementRule(PatternList.class), new ElementRule(TreeModel.class), new ElementRule(BranchRateModel.class, true), new ElementRule(SubstitutionModel.class, true), new ElementRule(Parameter.class, true)};

    @Override
    public String getParserName() {
        return STRUCTURED_COALESCENT;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        int n;
        TaxonList taxonList = null;
        if (xMLObject.hasChildNamed(INCLUDE)) {
            taxonList = (TaxonList)xMLObject.getElementFirstChild(INCLUDE);
        }
        ArrayList<TaxonList> arrayList = new ArrayList<TaxonList>();
        if (xMLObject.hasChildNamed(EXCLUDE)) {
            XMLObject xMLObject2 = xMLObject.getChild(EXCLUDE);
            for (n = 0; n < xMLObject2.getChildCount(); n += 1) {
                arrayList.add((TaxonList)xMLObject2.getChild(n));
            }
        }
        int n2 = 2;
        if (xMLObject.hasAttribute(SUBINTERVALS) && (n2 = xMLObject.getIntegerAttribute(SUBINTERVALS)) != 2) {
            throw new XMLParseException("The number of subintervals currently has to be set to 2.");
        }
        n = xMLObject.getAttribute(MAP_RECONSTRUCTION, false).booleanValue() ? 1 : 0;
        BranchRateModel branchRateModel = (BranchRateModel)xMLObject.getChild(BranchRateModel.class);
        PatternList patternList = (PatternList)xMLObject.getChild(PatternList.class);
        DataType dataType = patternList.getDataType();
        String string = xMLObject.getAttribute("stateTagName", "states");
        TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
        GeneralSubstitutionModel generalSubstitutionModel = (GeneralSubstitutionModel)xMLObject.getChild(GeneralSubstitutionModel.class);
        Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
        if (parameter.getDimension() != 1 && generalSubstitutionModel.getDataType().getStateCount() != parameter.getDimension()) {
            throw new XMLParseException("Mismatch between rate matrix and deme count.");
        }
        if (treeModel != null) {
            try {
                if (USE_OLD_CODE.booleanValue()) {
                    return new OldStructuredCoalescentLikelihood(treeModel, branchRateModel, parameter, patternList, generalSubstitutionModel, n2, taxonList, arrayList);
                }
                return new StructuredCoalescentLikelihood(treeModel, branchRateModel, parameter, patternList, dataType, string, generalSubstitutionModel, n2, taxonList, arrayList, n != 0);
            }
            catch (TreeUtils.MissingTaxonException missingTaxonException) {
                throw new XMLParseException("treeModel missing a taxon from taxon list in " + this.getParserName() + " element");
            }
        }
        throw new XMLParseException("");
    }

    @Override
    public String getParserDescription() {
        return "A Bayesian structured coalescent approximation model.";
    }

    @Override
    public Class getReturnType() {
        return OldStructuredCoalescentLikelihood.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

