/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.PiecewiseConstantPopulation;
import dr.evolution.coalescent.PiecewiseExponentialPopulation;
import dr.evolution.coalescent.PiecewiseLinearPopulation;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;

public class PiecewisePopulationModel
extends DemographicModel {
    private Parameter N0Parameter;
    private Parameter growthRatesParameter;
    private DemographicFunction piecewiseFunction = null;
    private final int epochCount;

    public PiecewisePopulationModel(String string, Parameter parameter, double[] dArray, boolean bl, Units.Type type) {
        super(string);
        this.epochCount = dArray.length + 1;
        if (parameter.getDimension() != this.epochCount) {
            throw new IllegalArgumentException("epochSize parameter must have the same dimensions as the number of epochs: (" + this.epochCount + ") but instead has " + parameter.getDimension() + "!");
        }
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension()));
        this.setUnits(type);
        this.piecewiseFunction = bl ? new PiecewiseLinearPopulation(dArray, new double[parameter.getDimension()], type) : new PiecewiseConstantPopulation(dArray, new double[parameter.getDimension()], type);
    }

    public PiecewisePopulationModel(String string, Parameter parameter, Parameter parameter2, double[] dArray, Units.Type type) {
        super(string);
        this.epochCount = dArray.length + 1;
        this.N0Parameter = parameter;
        this.growthRatesParameter = parameter2;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension()));
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, parameter2.getDimension()));
        this.setUnits(type);
        int n = parameter.getDimension();
        int n2 = parameter2.getDimension();
        if (n == this.epochCount && n2 == 1) {
            this.piecewiseFunction = new PiecewiseExponentialPopulation(dArray, new double[parameter.getDimension()], parameter2.getParameterValue(0), type);
        } else if (n == 1 && n2 == this.epochCount) {
            this.piecewiseFunction = new PiecewiseExponentialPopulation(dArray, parameter.getParameterValue(0), new double[parameter2.getDimension()], type);
        } else if (parameter2.getDimension() != this.epochCount) {
            throw new IllegalArgumentException("growthRate parameter must have the same dimension as the number of epochs: (" + this.epochCount + ") but instead has " + parameter.getDimension() + "!");
        }
        this.addStatistic(new GrowthRateStatistic());
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        if (this.growthRatesParameter != null) {
            int n;
            for (n = 0; n < this.N0Parameter.getDimension(); ++n) {
                this.piecewiseFunction.setArgument(n, this.N0Parameter.getParameterValue(n));
            }
            for (n = 0; n < this.growthRatesParameter.getDimension(); ++n) {
                this.piecewiseFunction.setArgument(n + this.N0Parameter.getDimension(), this.growthRatesParameter.getParameterValue(n));
            }
        } else {
            for (int i = 0; i < this.N0Parameter.getDimension(); ++i) {
                this.piecewiseFunction.setArgument(i, this.N0Parameter.getParameterValue(i));
            }
        }
        return this.piecewiseFunction;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    protected void handleParameterChangedEvent(Parameter parameter, int n) {
        if (parameter == this.N0Parameter) {
            // empty if block
        }
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    public class GrowthRateStatistic
    extends Statistic.Abstract {
        public GrowthRateStatistic() {
            super("growthRate");
        }

        @Override
        public int getDimension() {
            return ((PiecewiseExponentialPopulation)PiecewisePopulationModel.this.piecewiseFunction).getEpochCount();
        }

        @Override
        public double getStatisticValue(int n) {
            return ((PiecewiseExponentialPopulation)PiecewisePopulationModel.this.piecewiseFunction).getEpochGrowthRate(n);
        }
    }
}

