/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.MutableTreeListener;
import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TransformableTree;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.MutableTaxonListListener;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.continuous.AncestralTaxonInTree;
import dr.evomodel.tree.TreeChangedEvent;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AncestralTraitTreeModel
extends AbstractModel
implements MutableTreeModel,
TransformableTree,
Citable {
    private static final boolean DEBUG = false;
    private final int ancestorCount;
    private final int treeExternalCount;
    private final int treeInternalCount;
    private final int externalCount;
    private final int internalCount;
    private int extraInternal;
    private ShadowNode[] nodes;
    private ShadowNode[] storedNodes;
    private ShadowNode root;
    private int storedRootNumber;
    private final MutableTreeModel treeModel;
    private final List<AncestralTaxonInTree> ancestors;
    private final Map<BitSet, AncestralTaxonInTree> clampList = new HashMap<BitSet, AncestralTaxonInTree>();
    private final Map<Integer, AncestralTaxonInTree> nodeToClampMap = new HashMap<Integer, AncestralTaxonInTree>();
    private boolean validShadowTree = false;
    private boolean savedValidShadowTree;

    @Override
    public NodeRef getOriginalNode(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        ShadowNode shadowNode = (ShadowNode)nodeRef;
        return shadowNode.getOriginalNode();
    }

    @Override
    public NodeRef getTransformedNode(NodeRef nodeRef) {
        return new TransformableTree.BasicNode(this.mapOriginalToShadowNumber(nodeRef.getNumber()));
    }

    public static String toString(ShadowNode[] shadowNodeArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ShadowNode shadowNode : shadowNodeArray) {
            if (shadowNode != null) {
                stringBuilder.append(shadowNode.toString()).append("\n");
                continue;
            }
            stringBuilder.append("null\n");
        }
        stringBuilder.append("root = ").append(n);
        return stringBuilder.toString();
    }

    public AncestralTraitTreeModel(String string, MutableTreeModel mutableTreeModel, List<AncestralTaxonInTree> list) {
        super(string);
        this.treeModel = mutableTreeModel;
        this.ancestors = list;
        this.ancestorCount = list.size();
        this.treeExternalCount = this.treeModel.getExternalNodeCount();
        this.treeInternalCount = this.treeModel.getInternalNodeCount();
        this.externalCount = this.treeExternalCount + this.ancestorCount;
        this.internalCount = this.treeInternalCount + this.ancestorCount;
        this.addModel(mutableTreeModel);
        int n = 0;
        for (AncestralTaxonInTree ancestralTaxonInTree : list) {
            this.addRestrictedPartials(ancestralTaxonInTree, n);
            ++n;
        }
        this.nodes = new ShadowNode[this.externalCount + this.internalCount];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = new ShadowNode();
        }
    }

    @Override
    public Tree getOriginalTree() {
        return this.treeModel;
    }

    private void checkShadowTree() {
        if (!this.validShadowTree) {
            this.buildShadowTree();
            this.validShadowTree = true;
        }
    }

    private void buildShadowTree() {
        this.setupClamps();
        for (ShadowNode shadowNode : this.nodes) {
            shadowNode.setUnused();
        }
        this.extraInternal = 0;
        this.root = this.buildRecursivelyShadowTree(this.treeModel.getRoot(), null);
        this.validShadowTree = true;
    }

    private void storeNode(ShadowNode shadowNode) {
        this.nodes[shadowNode.getNumber()] = shadowNode;
    }

    private ShadowNode buildRecursivelyShadowTree(NodeRef nodeRef, ShadowNode shadowNode) {
        int n = nodeRef.getNumber();
        int n2 = this.mapOriginalToShadowNumber(n);
        ShadowNode shadowNode2 = new ShadowNode(n2, nodeRef, null);
        shadowNode2.parent = shadowNode;
        this.storeNode(shadowNode2);
        ShadowNode shadowNode3 = shadowNode2;
        if (this.nodeToClampMap.containsKey(nodeRef.getNumber())) {
            AncestralTaxonInTree ancestralTaxonInTree = this.nodeToClampMap.get(nodeRef.getNumber());
            int n3 = this.treeExternalCount + ancestralTaxonInTree.getIndex();
            ShadowNode shadowNode4 = new ShadowNode(n3, null, ancestralTaxonInTree);
            shadowNode4.parent = shadowNode2;
            shadowNode2.child1 = shadowNode4;
            this.storeNode(shadowNode4);
            ShadowNode shadowNode5 = new ShadowNode(this.externalCount + this.treeInternalCount + this.extraInternal, null, null);
            shadowNode5.parent = shadowNode2;
            shadowNode2.child0 = shadowNode5;
            this.storeNode(shadowNode5);
            ++this.extraInternal;
            shadowNode2 = shadowNode5;
        }
        if (!this.treeModel.isExternal(nodeRef)) {
            shadowNode2.child0 = this.buildRecursivelyShadowTree(this.treeModel.getChild(nodeRef, 0), shadowNode2);
            shadowNode2.child1 = this.buildRecursivelyShadowTree(this.treeModel.getChild(nodeRef, 1), shadowNode2);
        }
        return shadowNode3;
    }

    private int mapOriginalToShadowNumber(int n) {
        assert (n >= 0);
        assert (n < this.treeExternalCount + this.treeInternalCount);
        int n2 = n;
        if (n >= this.treeExternalCount) {
            n2 += this.ancestorCount;
        }
        return n2;
    }

    @Override
    public String toString() {
        return TreeUtils.newick(this);
    }

    @Override
    public boolean isVariable() {
        return this.treeModel instanceof AbstractModel && ((AbstractModel)((Object)this.treeModel)).isVariable();
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        ShadowNode shadowNode = (ShadowNode)nodeRef;
        int n = shadowNode.getOriginalNumber();
        if (n >= 0) {
            return this.treeModel.getNodeHeight(shadowNode.getOriginalNode());
        }
        double d = this.treeModel.getNodeHeight(shadowNode.parent.getOriginalNode());
        if (shadowNode.isExternal()) {
            double d2 = shadowNode.ancestor.getPseudoBranchLength();
            return d - d2;
        }
        return d;
    }

    @Override
    public double getBranchLength(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        ShadowNode shadowNode = (ShadowNode)nodeRef;
        if (!shadowNode.isUsed()) {
            return 0.0;
        }
        int n = shadowNode.getOriginalNumber();
        if (n >= 0) {
            return this.treeModel.getBranchLength(shadowNode.getOriginalNode());
        }
        if (shadowNode.isExternal()) {
            return shadowNode.ancestor.getPseudoBranchLength();
        }
        return 0.0;
    }

    private void storeNodeStructure() {
        int n;
        int n2 = this.nodes.length;
        if (this.storedNodes == null) {
            this.storedNodes = new ShadowNode[n2];
            for (n = 0; n < n2; ++n) {
                this.storedNodes[n] = new ShadowNode();
            }
        }
        for (n = 0; n < n2; ++n) {
            this.storedNodes[n].adoptValues(this.nodes[n], this.storedNodes);
        }
    }

    @Override
    protected void storeState() {
        assert (this.nodes != null);
        this.savedValidShadowTree = this.validShadowTree;
        if (this.validShadowTree) {
            this.storeNodeStructure();
            this.storedRootNumber = this.root.getNumber();
        }
    }

    @Override
    protected void restoreState() {
        assert (this.storedNodes != null);
        this.validShadowTree = this.savedValidShadowTree;
        if (this.validShadowTree) {
            ShadowNode[] shadowNodeArray = this.nodes;
            this.nodes = this.storedNodes;
            this.storedNodes = shadowNodeArray;
            this.root = this.nodes[this.storedRootNumber];
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model != this.treeModel) {
            if (!(model instanceof AncestralTaxonInTree)) throw new IllegalArgumentException("Illegal model");
            if (!this.ancestors.contains(model)) throw new IllegalArgumentException("Illegal model");
            this.fireModelChanged(new TreeChangedEvent.WholeTree());
            return;
        }
        if (!(object instanceof TreeChangedEvent)) {
            if (!(object instanceof Parameter)) throw new IllegalArgumentException("TreeModel should not generate other objects");
            return;
        }
        TreeChangedEvent treeChangedEvent = (TreeChangedEvent)object;
        if (treeChangedEvent.isTreeChanged()) {
            this.validShadowTree = false;
            this.fireModelChanged(new TreeChangedEvent.WholeTree());
            return;
        }
        if (!treeChangedEvent.isNodeChanged()) throw new IllegalArgumentException("TreeModel should not generate other events");
        NodeRef nodeRef = treeChangedEvent.getNode();
        if (nodeRef != null) {
            ShadowNode shadowNode = this.nodes[this.mapOriginalToShadowNumber(nodeRef.getNumber())];
            if (!shadowNode.isExternal() && shadowNode.child1.ancestor != null) {
                this.fireModelChanged(new RemappedTreeChangeEvent(treeChangedEvent, shadowNode), n);
                shadowNode = shadowNode.child0;
            }
            object = new RemappedTreeChangeEvent(treeChangedEvent, shadowNode);
        }
        this.fireModelChanged(object, n);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public NodeRef getRoot() {
        this.checkShadowTree();
        return this.root;
    }

    @Override
    public int getNodeCount() {
        return this.externalCount + this.internalCount;
    }

    @Override
    public NodeRef getNode(int n) {
        assert (n >= 0 && n < this.externalCount + this.internalCount);
        this.checkShadowTree();
        return this.nodes[n];
    }

    @Override
    public NodeRef getInternalNode(int n) {
        assert (n >= 0 && n < this.internalCount);
        this.checkShadowTree();
        return this.nodes[n + this.externalCount];
    }

    @Override
    public NodeRef getExternalNode(int n) {
        assert (n >= 0 && n < this.externalCount);
        this.checkShadowTree();
        return this.nodes[n];
    }

    @Override
    public int getExternalNodeCount() {
        return this.externalCount;
    }

    @Override
    public int getInternalNodeCount() {
        return this.internalCount;
    }

    @Override
    public Taxon getNodeTaxon(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        int n = ((ShadowNode)nodeRef).getOriginalNumber();
        if (n >= 0) {
            return this.treeModel.getNodeTaxon(this.treeModel.getNode(n));
        }
        return this.getTaxonByTreeIndex(nodeRef.getNumber());
    }

    @Override
    public boolean hasNodeHeights() {
        return this.treeModel.hasNodeHeights();
    }

    @Override
    public boolean hasBranchLengths() {
        return this.treeModel.hasBranchLengths();
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public boolean isExternal(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        return ((ShadowNode)nodeRef).isExternal();
    }

    @Override
    public boolean isRoot(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        return nodeRef == this.root;
    }

    @Override
    public int getChildCount(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        if (((ShadowNode)nodeRef).isExternal()) {
            return 0;
        }
        return 2;
    }

    @Override
    public NodeRef getChild(NodeRef nodeRef, int n) {
        assert (nodeRef != null);
        this.checkShadowTree();
        return ((ShadowNode)nodeRef).getChild(n);
    }

    @Override
    public NodeRef getParent(NodeRef nodeRef) {
        assert (nodeRef != null);
        this.checkShadowTree();
        return ((ShadowNode)nodeRef).parent;
    }

    @Override
    public Tree getCopy() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double[] getMultivariateNodeTrait(NodeRef nodeRef, String string) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setMultivariateTrait(NodeRef nodeRef, String string, double[] dArray) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public boolean beginTreeEdit() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void endTreeEdit() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void replaceChild(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setRoot(NodeRef nodeRef) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setNodeRate(NodeRef nodeRef, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setBranchLength(NodeRef nodeRef, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setNodeAttribute(NodeRef nodeRef, String string, Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void addMutableTreeListener(MutableTreeListener mutableTreeListener) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setAttribute(String string, Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Object getAttribute(String string) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Iterator<String> getAttributeNames() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int addTaxon(Taxon taxon) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public boolean removeTaxon(Taxon taxon) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setTaxonId(int n, String string) {
        this.treeModel.setTaxonId(n, string);
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setTaxonAttribute(int n, String string, Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void addMutableTaxonListListener(MutableTaxonListListener mutableTaxonListListener) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int getTaxonCount() {
        return this.treeModel.getTaxonCount() + this.ancestorCount;
    }

    @Override
    public Taxon getTaxon(int n) {
        Taxon taxon = n < this.treeExternalCount ? this.treeModel.getTaxon(n) : this.getTaxonByTreeIndex(n);
        return taxon;
    }

    @Override
    public String getTaxonId(int n) {
        String string;
        if (n < this.treeExternalCount) {
            string = this.treeModel.getTaxonId(n);
        } else {
            Taxon taxon = this.getTaxonByTreeIndex(n);
            string = taxon.getId();
        }
        return string;
    }

    @Override
    public int getTaxonIndex(String string) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getTaxonId(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        int n = this.treeModel.getTaxonIndex(taxon);
        if (n != -1) {
            return n;
        }
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        if (n < this.treeModel.getExternalNodeCount()) {
            return this.treeModel.getTaxonAttribute(n, string);
        }
        Taxon taxon = this.getTaxonByTreeIndex(n);
        if (taxon != null) {
            return taxon.getAttribute(string);
        }
        return null;
    }

    @Override
    public Iterator<Taxon> iterator() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Units.Type getUnits() {
        return this.treeModel.getUnits();
    }

    @Override
    public void setUnits(Units.Type type) {
        this.treeModel.setUnits(type);
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Bayesian estimation of Pagel's lambda";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.VRANCKEN_2015_SIMULTANEOUSLY);
    }

    private Taxon getTaxonByTreeIndex(int n) {
        return this.ancestors.get(n - this.treeExternalCount).getTaxon();
    }

    private void setupClamps() {
        this.nodeToClampMap.clear();
        AncestralTraitTreeModel.recursiveSetupMrcaClamps(this.treeModel, this.treeModel.getRoot(), new BitSet(), this.clampList, this.nodeToClampMap);
        AncestralTraitTreeModel.setupAncestralPathClamps(this.treeModel, this.clampList, this.nodeToClampMap);
    }

    private static void setupAncestralPathClamps(Tree tree, Map<BitSet, AncestralTaxonInTree> map, Map<Integer, AncestralTaxonInTree> map2) {
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = tree.getExternalNode(i);
            BitSet bitSet = new BitSet();
            bitSet.set(nodeRef.getNumber());
            if (!map.containsKey(bitSet)) continue;
            AncestralTaxonInTree ancestralTaxonInTree = map.get(bitSet);
            double d = ancestralTaxonInTree.getHeight();
            assert (d > 0.0);
            NodeRef nodeRef2 = tree.getParent(nodeRef);
            double d2 = tree.getNodeHeight(nodeRef2);
            while (d2 < d && nodeRef2 != tree.getRoot()) {
                nodeRef2 = tree.getParent(nodeRef2);
                d2 = tree.getNodeHeight(nodeRef2);
            }
            ancestralTaxonInTree.setNode(nodeRef2);
            map2.put(nodeRef2.getNumber(), ancestralTaxonInTree);
        }
    }

    private static void recursiveSetupMrcaClamps(Tree tree, NodeRef nodeRef, BitSet bitSet, Map<BitSet, AncestralTaxonInTree> map, Map<Integer, AncestralTaxonInTree> map2) {
        if (tree.isExternal(nodeRef)) {
            bitSet.set(nodeRef.getNumber());
        } else {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                BitSet bitSet2 = new BitSet();
                AncestralTraitTreeModel.recursiveSetupMrcaClamps(tree, nodeRef2, bitSet2, map, map2);
                bitSet.or(bitSet2);
            }
            if (map.containsKey(bitSet)) {
                AncestralTaxonInTree ancestralTaxonInTree = map.get(bitSet);
                ancestralTaxonInTree.setNode(nodeRef);
                map2.put(nodeRef.getNumber(), ancestralTaxonInTree);
            }
        }
    }

    private void addRestrictedPartials(AncestralTaxonInTree ancestralTaxonInTree, int n) {
        this.clampList.put(ancestralTaxonInTree.getTipBitSet(), ancestralTaxonInTree);
        this.addModel(ancestralTaxonInTree);
        ancestralTaxonInTree.setIndex(n);
    }

    private class RemappedTreeChangeEvent
    implements TreeChangedEvent {
        private final TreeChangedEvent event;
        private final NodeRef node;

        private RemappedTreeChangeEvent(TreeChangedEvent treeChangedEvent, NodeRef nodeRef) {
            this.event = treeChangedEvent;
            this.node = nodeRef;
        }

        @Override
        public int getIndex() {
            return this.event.getIndex();
        }

        @Override
        public NodeRef getNode() {
            return this.node;
        }

        @Override
        public Parameter getParameter() {
            return this.event.getParameter();
        }

        @Override
        public boolean isNodeChanged() {
            return this.event.isNodeChanged();
        }

        @Override
        public boolean isTreeChanged() {
            return this.event.isTreeChanged();
        }

        @Override
        public boolean isNodeParameterChanged() {
            return this.event.isNodeParameterChanged();
        }

        @Override
        public boolean isHeightChanged() {
            return this.event.isHeightChanged();
        }
    }

    public class ShadowNode
    implements NodeRef {
        private int number = -1;
        private int originalNumber = -1;
        private AncestralTaxonInTree ancestor = null;
        private ShadowNode child0 = null;
        private ShadowNode child1 = null;
        private ShadowNode parent = null;
        private boolean used = false;

        private ShadowNode() {
        }

        private ShadowNode(int n, NodeRef nodeRef, AncestralTaxonInTree ancestralTaxonInTree) {
            this.number = n;
            this.originalNumber = nodeRef != null ? nodeRef.getNumber() : -1;
            this.ancestor = ancestralTaxonInTree;
            this.used = true;
        }

        private void adoptValues(ShadowNode shadowNode, ShadowNode[] shadowNodeArray) {
            this.number = shadowNode.number;
            this.originalNumber = shadowNode.originalNumber;
            this.ancestor = shadowNode.ancestor;
            this.used = shadowNode.used;
            this.child0 = shadowNode.child0 != null ? shadowNodeArray[shadowNode.child0.getNumber()] : null;
            this.child1 = shadowNode.child1 != null ? shadowNodeArray[shadowNode.child1.getNumber()] : null;
            this.parent = shadowNode.parent != null ? shadowNodeArray[shadowNode.parent.getNumber()] : null;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public void setNumber(int n) {
            throw new RuntimeException("Node number is not modifiable");
        }

        private int getOriginalNumber() {
            return this.originalNumber;
        }

        private NodeRef getOriginalNode() {
            return this.originalNumber >= 0 ? AncestralTraitTreeModel.this.treeModel.getNode(this.originalNumber) : null;
        }

        private NodeRef getChild(int n) {
            if (n == 0) {
                return this.child0;
            }
            if (n == 1) {
                return this.child1;
            }
            throw new IllegalArgumentException("Binary trees only!");
        }

        private boolean isExternal() {
            return this.child0 == null && this.child1 == null;
        }

        public String toString() {
            int n = this.parent != null ? this.parent.getNumber() : -1;
            int n2 = this.child0 != null ? this.child0.getNumber() : -1;
            int n3 = this.child1 != null ? this.child1.getNumber() : -1;
            String string = this.ancestor != null ? this.ancestor.getTaxon().getId() : "-1";
            String string2 = this.used ? "true" : "false";
            double d = AncestralTraitTreeModel.this.getNodeHeight(this);
            boolean bl = this.isExternal();
            int n4 = AncestralTraitTreeModel.this.getChildCount(this);
            return "node " + this.number + " " + n + " " + n2 + " " + n3 + " : " + this.originalNumber + " " + string + " " + string2 + " " + d + " " + bl + " " + n4;
        }

        private boolean isUsed() {
            return this.used;
        }

        private void setUnused() {
            this.used = false;
        }
    }
}

