/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.io.Importer;
import dr.evolution.io.NexusImporter;
import dr.evolution.io.TreeTrace;
import dr.evolution.tree.Clade;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evomodel.tree.AbstractCladeImportanceDistribution;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import dr.math.MathUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Set;

public class ConditionalCladeFrequency
extends AbstractCladeImportanceDistribution {
    private double EPSILON;
    private long samples = 0L;
    private HashMap<BitSet, Clade> cladeProbabilities = new HashMap();
    private HashMap<BitSet, HashMap<BitSet, Clade>> cladeCoProbabilities = new HashMap();
    private TreeTrace[] traces;
    private int burnin;

    public ConditionalCladeFrequency(Tree tree, double d) {
        this.EPSILON = d;
    }

    public ConditionalCladeFrequency(TreeTrace[] treeTraceArray, double d, int n, boolean bl) {
        this.EPSILON = d;
        this.traces = treeTraceArray;
        int n2 = Integer.MAX_VALUE;
        for (TreeTrace treeTrace : treeTraceArray) {
            if (treeTrace.getMaximumState() >= n2) continue;
            n2 = treeTrace.getMaximumState();
        }
        if (n < 0 || n >= n2) {
            this.burnin = n2 / (10 * treeTraceArray[0].getStepSize());
            if (bl) {
                System.out.println("WARNING: Burn-in larger than total number of states - using 10% of smallest trace");
            }
        } else {
            this.burnin = n;
        }
        this.analyzeTrace(bl);
    }

    public void analyzeTrace(boolean bl) {
        if (bl && this.traces.length > 1) {
            System.out.println("Combining " + this.traces.length + " traces.");
        }
        Tree tree = this.getTree(0);
        for (TreeTrace treeTrace : this.traces) {
            int n = treeTrace.getTreeCount(this.burnin * treeTrace.getStepSize());
            double d = (double)n / 60.0;
            int n2 = 1;
            if (bl) {
                System.out.println("Analyzing " + n + " trees...");
                System.out.println("0              25             50             75            100");
                System.out.println("|--------------|--------------|--------------|--------------|");
                System.out.print("*");
            }
            for (int i = 1; i < n; ++i) {
                tree = treeTrace.getTree(i, this.burnin * treeTrace.getStepSize());
                this.addTree(tree);
                if (i < (int)Math.round((double)n2 * d) || n2 > 60) continue;
                if (bl) {
                    System.out.print("*");
                    System.out.flush();
                }
                ++n2;
            }
            if (!bl) continue;
            System.out.println("*");
        }
    }

    public void report(Reader reader) throws IOException, Importer.ImportException {
        System.err.println("making report");
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        if (string.toUpperCase().startsWith("#NEXUS")) {
            Tree[] treeArray;
            NexusImporter nexusImporter = new NexusImporter(bufferedReader);
            for (Tree tree : treeArray = nexusImporter.importTrees(null)) {
                arrayList.add(tree);
                SimpleTree simpleTree = new SimpleTree(tree);
                System.out.println("Estimated marginal posterior by condiational clade frequencies:");
                System.out.println(this.getTreeProbability(simpleTree) + "\t\t" + simpleTree);
            }
        } else {
            throw new RuntimeException("Could not read reference tree. Only Nexus format is supported.");
        }
        System.out.flush();
    }

    @Override
    public double getTreeProbability(Tree tree) {
        double d = 0.0;
        ArrayList<Clade> arrayList = new ArrayList<Clade>();
        ArrayList<Clade> arrayList2 = new ArrayList<Clade>();
        this.getNonComplementaryClades(tree, tree.getRoot(), arrayList2, arrayList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            BitSet bitSet;
            HashMap<BitSet, Clade> hashMap;
            Clade clade = (Clade)arrayList.get(i);
            Clade clade2 = (Clade)arrayList2.get(i);
            double d2 = this.EPSILON;
            double d3 = 0.0;
            BitSet bitSet2 = clade2.getBits();
            if (this.cladeProbabilities.containsKey(bitSet2)) {
                d3 += (double)this.cladeProbabilities.get(bitSet2).getSampleCount();
            }
            if (this.cladeCoProbabilities.containsKey(bitSet2) && (hashMap = this.cladeCoProbabilities.get(bitSet2)).containsKey(bitSet = clade.getBits())) {
                d2 += (double)hashMap.get(bitSet).getSampleCount();
            }
            double d4 = Math.pow(2.0, clade2.getSize() - 1) - 1.0;
            d += Math.log(d2 / (d3 += this.EPSILON * d4));
        }
        return d;
    }

    public double getTreeProbability(Tree tree, HashMap<String, Integer> hashMap) {
        double d = 0.0;
        ArrayList<Clade> arrayList = new ArrayList<Clade>();
        ArrayList<Clade> arrayList2 = new ArrayList<Clade>();
        this.getNonComplementaryClades(tree, tree.getRoot(), arrayList2, arrayList, hashMap);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            BitSet bitSet;
            HashMap<BitSet, Clade> hashMap2;
            Clade clade = (Clade)arrayList.get(i);
            Clade clade2 = (Clade)arrayList2.get(i);
            double d2 = this.EPSILON;
            double d3 = 0.0;
            BitSet bitSet2 = clade2.getBits();
            if (this.cladeProbabilities.containsKey(bitSet2)) {
                d3 += (double)this.cladeProbabilities.get(bitSet2).getSampleCount();
            }
            if (this.cladeCoProbabilities.containsKey(bitSet2) && (hashMap2 = this.cladeCoProbabilities.get(bitSet2)).containsKey(bitSet = clade.getBits())) {
                d2 += (double)hashMap2.get(bitSet).getSampleCount();
            }
            double d4 = Math.pow(2.0, clade2.getSize() - 1) - 1.0;
            d += Math.log(d2 / (d3 += this.EPSILON * d4));
        }
        return d;
    }

    @Override
    public double splitClade(Clade clade, Clade[] cladeArray) {
        double d = Math.pow(2.0, clade.getSize() - 1) - 1.0;
        double d2 = 0.0;
        if (this.cladeCoProbabilities.containsKey(clade.getBits())) {
            Object object;
            HashMap<BitSet, Clade> hashMap = this.cladeCoProbabilities.get(clade.getBits());
            double d3 = 0.0;
            double d4 = 0.0;
            Set<BitSet> set = hashMap.keySet();
            for (BitSet bitSet : set) {
                object = hashMap.get(bitSet);
                if (clade.getSize() > ((Clade)object).getSize() + 1) {
                    d4 += ((double)((Clade)object).getSampleCount() + this.EPSILON) / 2.0;
                    d3 += 0.5;
                    continue;
                }
                d4 += (double)((Clade)object).getSampleCount() + this.EPSILON;
                d3 += 1.0;
            }
            double d5 = MathUtils.nextDouble() * (d4 += this.EPSILON * (d - d3));
            for (BitSet bitSet : set) {
                Clade clade2 = hashMap.get(bitSet);
                d5 = clade.getSize() > clade2.getSize() + 1 ? (d5 -= ((double)clade2.getSampleCount() + this.EPSILON) / 2.0) : (d5 -= (double)clade2.getSampleCount() + this.EPSILON);
                if (!(d5 < 0.0)) continue;
                cladeArray[0] = clade2;
                d2 = ((double)clade2.getSampleCount() + this.EPSILON) / d4;
                break;
            }
            if (d5 >= 0.0) {
                Clade clade3;
                d2 = this.EPSILON / d4;
                while (true) {
                    BitSet bitSet;
                    object = (BitSet)clade.getBits().clone();
                    int n = -1;
                    do {
                        if ((n = ((BitSet)object).nextSetBit(n + 1)) <= -1 || !MathUtils.nextBoolean()) continue;
                        ((BitSet)object).clear(n);
                    } while (n > -1);
                    if (((BitSet)object).cardinality() == 0 || ((BitSet)object).cardinality() == clade.getSize()) continue;
                    bitSet = (BitSet)((BitSet)object).clone();
                    bitSet.xor(clade.getBits());
                    if (!hashMap.containsKey(object) && !hashMap.containsKey(bitSet)) break;
                }
                cladeArray[0] = clade3 = new Clade((BitSet)object, 0.9999 * clade.getHeight());
                BitSet bitSet = (BitSet)cladeArray[0].getBits().clone();
                bitSet.xor(clade.getBits());
                cladeArray[1] = new Clade(bitSet, 0.9999 * clade.getHeight());
            } else {
                object = (BitSet)cladeArray[0].getBits().clone();
                ((BitSet)object).xor(clade.getBits());
                cladeArray[1] = hashMap.get(object);
                if (cladeArray[1] == null) {
                    cladeArray[1] = new Clade((BitSet)object, 0.9999 * clade.getHeight());
                }
            }
        } else {
            BitSet bitSet;
            d2 = 1.0 / d;
            do {
                bitSet = (BitSet)clade.getBits().clone();
                int n = -1;
                do {
                    if ((n = bitSet.nextSetBit(n + 1)) <= -1 || !MathUtils.nextBoolean()) continue;
                    bitSet.clear(n);
                } while (n > -1);
            } while (bitSet.cardinality() == 0 || bitSet.cardinality() == clade.getSize());
            Clade clade4 = new Clade(bitSet, 0.9999 * clade.getHeight());
            clade4.addHeight(0.9999 * clade.getHeight());
            cladeArray[0] = clade4;
            BitSet bitSet2 = (BitSet)cladeArray[0].getBits().clone();
            bitSet2.xor(clade.getBits());
            cladeArray[1] = new Clade(bitSet2, 0.9999 * clade.getHeight());
            clade4.addHeight(0.9999 * clade.getHeight());
        }
        return Math.log(d2);
    }

    @Override
    public double getChanceForNodeHeights(TreeModel treeModel, Likelihood likelihood) {
        double d = 0.0;
        NodeRef nodeRef = treeModel.getRoot();
        Clade clade = this.getClade(treeModel, nodeRef);
        int n = treeModel.getChildCount(nodeRef);
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef2 = treeModel.getChild(nodeRef, i);
            if (treeModel.isExternal(nodeRef2)) continue;
        }
        return d;
    }

    @Override
    public double setNodeHeights(TreeModel treeModel, Likelihood likelihood) {
        double d = 0.0;
        NodeRef nodeRef = treeModel.getRoot();
        Clade clade = this.getClade(treeModel, nodeRef);
        int n = treeModel.getChildCount(nodeRef);
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef2 = treeModel.getChild(nodeRef, i);
            if (treeModel.isExternal(nodeRef2)) continue;
        }
        return d;
    }

    public final Tree getTree(int n) {
        int n2 = 0;
        int n3 = 0;
        for (TreeTrace treeTrace : this.traces) {
            if (n < (n3 += treeTrace.getTreeCount(this.burnin * treeTrace.getStepSize()))) {
                return treeTrace.getTree(n - n2, this.burnin * treeTrace.getStepSize());
            }
            n2 = n3;
        }
        throw new RuntimeException("Couldn't find tree " + n);
    }

    @Override
    public void addTree(Tree tree) {
        ++this.samples;
        ArrayList<Clade> arrayList = new ArrayList<Clade>();
        ArrayList<Clade> arrayList2 = new ArrayList<Clade>();
        this.getClades(tree, tree.getRoot(), arrayList2, arrayList);
        arrayList.add((Clade)arrayList2.get(arrayList2.size() - 1));
        arrayList2.add((Clade)arrayList.get(arrayList.size() - 1));
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            HashMap<Object, Object> hashMap;
            Clade clade;
            Clade clade2 = (Clade)arrayList.get(i);
            Clade clade3 = (Clade)arrayList2.get(i);
            if (this.cladeProbabilities.containsKey(clade2.getBits())) {
                clade = this.cladeProbabilities.get(clade2.getBits());
                clade.addHeight(clade2.getHeight());
            } else {
                clade2.addHeight(clade2.getHeight());
                this.cladeProbabilities.put(clade2.getBits(), clade2);
            }
            if (clade3.equals(clade2)) continue;
            if (this.cladeCoProbabilities.containsKey(clade3.getBits())) {
                hashMap = this.cladeCoProbabilities.get(clade3.getBits());
            } else {
                hashMap = new HashMap();
                this.cladeCoProbabilities.put(clade3.getBits(), hashMap);
            }
            if (hashMap.containsKey(clade2.getBits())) {
                clade = (Clade)hashMap.get(clade2.getBits());
                clade.addHeight(clade2.getHeight());
                continue;
            }
            clade = new Clade((BitSet)clade2.getBits().clone(), clade2.getHeight());
            clade.addHeight(clade2.getHeight());
            hashMap.put(clade2.getBits(), clade);
        }
    }

    public void addTree(Tree tree, HashMap<String, Integer> hashMap) {
        ++this.samples;
        ArrayList<Clade> arrayList = new ArrayList<Clade>();
        ArrayList<Clade> arrayList2 = new ArrayList<Clade>();
        this.getClades(tree, tree.getRoot(), arrayList2, arrayList, hashMap);
        arrayList.add((Clade)arrayList2.get(arrayList2.size() - 1));
        arrayList2.add((Clade)arrayList.get(arrayList.size() - 1));
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            HashMap<Object, Object> hashMap2;
            Clade clade;
            Clade clade2 = (Clade)arrayList.get(i);
            Clade clade3 = (Clade)arrayList2.get(i);
            if (this.cladeProbabilities.containsKey(clade2.getBits())) {
                clade = this.cladeProbabilities.get(clade2.getBits());
                clade.addHeight(clade2.getHeight());
            } else {
                clade2.addHeight(clade2.getHeight());
                this.cladeProbabilities.put(clade2.getBits(), clade2);
            }
            if (clade3.equals(clade2)) continue;
            if (this.cladeCoProbabilities.containsKey(clade3.getBits())) {
                hashMap2 = this.cladeCoProbabilities.get(clade3.getBits());
            } else {
                hashMap2 = new HashMap();
                this.cladeCoProbabilities.put(clade3.getBits(), hashMap2);
            }
            if (hashMap2.containsKey(clade2.getBits())) {
                clade = (Clade)hashMap2.get(clade2.getBits());
                clade.addHeight(clade2.getHeight());
                continue;
            }
            clade = new Clade((BitSet)clade2.getBits().clone(), clade2.getHeight());
            clade.addHeight(clade2.getHeight());
            hashMap2.put(clade2.getBits(), clade);
        }
    }

    public static ConditionalCladeFrequency analyzeLogFile(Reader[] readerArray, double d, int n, boolean bl) throws IOException {
        TreeTrace[] treeTraceArray = new TreeTrace[readerArray.length];
        for (int i = 0; i < readerArray.length; ++i) {
            try {
                treeTraceArray[i] = TreeTrace.loadTreeTrace(readerArray[i]);
            }
            catch (Importer.ImportException importException) {
                throw new RuntimeException(importException.toString());
            }
            readerArray[i].close();
        }
        return new ConditionalCladeFrequency(treeTraceArray, d, n, bl);
    }
}

