/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel.lineagespecific;

import beagle.Beagle;
import beagle.BeagleFactory;
import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.DataType;
import dr.evolution.tree.NodeRef;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.BufferIndexHelper;
import dr.evomodel.treelikelihood.SubstitutionModelDelegate;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class BeagleBranchLikelihood
implements Likelihood {
    private static final boolean DEBUG = true;
    private PatternList patternList;
    private TreeModel treeModel;
    private BranchModel branchModel;
    private SiteRateModel siteRateModel;
    private FrequencyModel freqModel;
    private BranchRateModel branchRateModel;
    private String id = null;
    private boolean used = true;
    private Beagle beagle;
    private BufferIndexHelper matrixBufferHelper;
    private BufferIndexHelper partialBufferHelper;
    private SubstitutionModelDelegate substitutionModelDelegate;
    int nodeCount;
    boolean[] updateNode;

    public BeagleBranchLikelihood(PatternList patternList, TreeModel treeModel, BranchModel branchModel, SiteRateModel siteRateModel, FrequencyModel frequencyModel, BranchRateModel branchRateModel) {
        this.patternList = patternList;
        this.treeModel = treeModel;
        this.branchModel = branchModel;
        this.siteRateModel = siteRateModel;
        this.freqModel = frequencyModel;
        this.branchRateModel = branchRateModel;
        this.loadBeagleInstance();
    }

    public double getBranchLogLikelihood(int n) {
        int n2 = 1;
        double[] dArray = new double[n2];
        double[] dArray2 = this.siteRateModel.getCategoryRates();
        this.beagle.setCategoryRates(dArray2);
        double[] dArray3 = this.siteRateModel.getCategoryProportions();
        this.beagle.setCategoryWeights(0, dArray3);
        double[] dArray4 = this.substitutionModelDelegate.getRootStateFrequencies();
        this.beagle.setStateFrequencies(0, dArray4);
        this.substitutionModelDelegate.updateSubstitutionModels(this.beagle);
        this.setTipPartials();
        this.updateNode = new boolean[this.nodeCount];
        Arrays.fill(this.updateNode, true);
        int n3 = n;
        NodeRef nodeRef = this.treeModel.getNode(n3);
        this.traverse(this.treeModel, nodeRef);
        NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
        this.traverse(this.treeModel, nodeRef2);
        int n4 = this.treeModel.getParent(nodeRef).getNumber();
        return dArray[0];
    }

    private boolean traverse(TreeModel treeModel, NodeRef nodeRef) {
        boolean bl = false;
        int n = nodeRef.getNumber();
        NodeRef nodeRef2 = treeModel.getParent(nodeRef);
        if (nodeRef2 != null && this.updateNode[n]) {
            double d = this.branchRateModel.getBranchRate(treeModel, nodeRef);
            double d2 = treeModel.getNodeHeight(nodeRef2);
            double d3 = treeModel.getNodeHeight(nodeRef);
            double d4 = d * (d2 - d3);
            this.substitutionModelDelegate.flipMatrixBuffer(n);
            this.substitutionModelDelegate.updateTransitionMatrices(this.beagle, new int[]{n}, new double[]{d4}, 1);
            System.out.println("At branch " + n);
            System.out.println(" Length " + d4 + ": node " + n + ", height=" + d3 + " parent " + nodeRef2);
            System.out.println(" Populating transition matrix buffer");
            this.updateNode[n] = false;
            bl = true;
        }
        if (!treeModel.isExternal(nodeRef)) {
            NodeRef nodeRef3 = treeModel.getChild(nodeRef, 0);
            boolean bl2 = this.traverse(treeModel, nodeRef3);
            NodeRef nodeRef4 = treeModel.getChild(nodeRef, 1);
            boolean bl3 = this.traverse(treeModel, nodeRef4);
            if (bl2 || bl3) {
                int[] nArray = new int[7];
                this.partialBufferHelper.flipOffset(n);
                nArray[0] = this.partialBufferHelper.getOffsetIndex(n);
                nArray[1] = -1;
                nArray[2] = -1;
                nArray[3] = this.partialBufferHelper.getOffsetIndex(nodeRef3.getNumber());
                nArray[4] = this.substitutionModelDelegate.getMatrixIndex(nodeRef3.getNumber());
                nArray[5] = this.partialBufferHelper.getOffsetIndex(nodeRef4.getNumber());
                nArray[6] = this.substitutionModelDelegate.getMatrixIndex(nodeRef4.getNumber());
                this.beagle.updatePartials(nArray, 1, -1);
                System.out.println("At branch " + n);
                System.out.println(" Child nodes updated");
                System.out.println(" Populating partial buffer");
                this.updateNode[n] = false;
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public double getLogLikelihood() {
        double d = 0.0;
        return d;
    }

    private void populateTransitionBuffers() {
        for (NodeRef nodeRef : this.treeModel.getNodes()) {
            int n = nodeRef.getNumber();
            this.matrixBufferHelper.flipOffset(n);
            int n2 = n;
            int[] nArray = new int[]{n2};
            double d = this.branchRateModel.getBranchRate(this.treeModel, nodeRef);
            double d2 = this.treeModel.getBranchLength(nodeRef);
            double d3 = d2 * d;
            this.substitutionModelDelegate.updateTransitionMatrices(this.beagle, nArray, new double[]{d3}, 1);
        }
    }

    private void setTipPartials() {
        int n = this.patternList.getPatternCount();
        int n2 = this.treeModel.getTaxonCount();
        for (int i = 0; i < n2; ++i) {
            String string = this.treeModel.getTaxonId(i);
            int n3 = this.patternList.getTaxonIndex(string);
            int[] nArray = new int[n];
            for (int j = 0; j < n; ++j) {
                nArray[j] = this.patternList.getPatternState(n3, j);
            }
            this.beagle.setTipStates(i, nArray);
        }
    }

    public void finalizeBeagle() throws Throwable {
        this.beagle.finalize();
    }

    private void loadBeagleInstance() {
        this.substitutionModelDelegate = new SubstitutionModelDelegate(this.treeModel, this.branchModel);
        DataType dataType = this.freqModel.getDataType();
        int n = this.patternList.getPatternCount();
        this.nodeCount = this.treeModel.getNodeCount();
        this.matrixBufferHelper = new BufferIndexHelper(this.nodeCount, 0);
        int n2 = this.treeModel.getExternalNodeCount();
        int n3 = this.treeModel.getInternalNodeCount();
        this.partialBufferHelper = new BufferIndexHelper(this.nodeCount, n2);
        BufferIndexHelper bufferIndexHelper = new BufferIndexHelper(n3 + 1, 0);
        int n4 = n2;
        int n5 = dataType.getStateCount();
        int n6 = n;
        int n7 = this.siteRateModel.getCategoryCount();
        int[] nArray = new int[]{0};
        long l = 0L;
        long l2 = 0L;
        this.beagle = BeagleFactory.loadBeagleInstance(n2, this.partialBufferHelper.getBufferCount(), n4, n5, n6, this.substitutionModelDelegate.getEigenBufferCount(), this.substitutionModelDelegate.getMatrixBufferCount(), n7, bufferIndexHelper.getBufferCount(), nArray, l, l2);
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LikelihoodColumn(this.getId() == null ? "likelihood" : this.getId())};
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public Model getModel() {
        return null;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public String prettyName() {
        return Likelihood.Abstract.getPrettyName(this);
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        return new HashSet<Likelihood>(Arrays.asList(this));
    }

    @Override
    public boolean isUsed() {
        return this.used;
    }

    @Override
    public void setUsed() {
        this.used = true;
    }

    @Override
    public boolean evaluateEarly() {
        return false;
    }

    private class LikelihoodColumn
    extends NumberColumn {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return BeagleBranchLikelihood.this.getLogLikelihood();
        }
    }
}

