/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.continuous.RestrictedPartials;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.continuous.cdi.ContinuousDiffusionIntegrator;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestrictedPartialsModel
extends AbstractModel {
    private final TreeModel treeModel;
    private final List<RestrictedPartials> restrictedPartialsList;
    private final ContinuousDiffusionIntegrator cdi;
    private boolean updateTreeMapping = true;
    private boolean updateRestrictedPartials = true;
    private final int startingPartialCount;
    private final int startingMatrixCount;
    private int partialsCount;
    private int matrixCount;
    private final int sparePartialIndex;
    protected Map<BitSet, RestrictedPartials> clampList = null;
    protected Map<NodeRef, RestrictedPartials> nodeToClampMap = null;
    protected boolean anyClamps = false;

    public RestrictedPartialsModel(String string, List<RestrictedPartials> list, int n, int n2) {
        super(string);
        this.treeModel = this.validateTreeModel(list);
        this.startingPartialCount = n;
        this.startingMatrixCount = n2;
        this.partialsCount = 0;
        this.matrixCount = 0;
        for (RestrictedPartials restrictedPartials : list) {
            restrictedPartials.setIndex(this.partialsCount + n);
            this.addRestrictedPartials(restrictedPartials);
            ++this.partialsCount;
        }
        this.sparePartialIndex = this.partialsCount + n;
        ++this.partialsCount;
        this.setupClamps();
        this.restrictedPartialsList = list;
        this.cdi = null;
    }

    public int getExtraPartialBufferCount() {
        return this.partialsCount;
    }

    public int getExtraMatrixBufferCount() {
        return this.matrixCount;
    }

    public void updatePartialRestrictions() {
        if (this.updateTreeMapping) {
            this.setupClamps();
            this.updateTreeMapping = false;
        }
        if (this.updateRestrictedPartials) {
            this.setupRestrictedPartials();
            this.updateRestrictedPartials = false;
        }
    }

    public boolean hasAnyPartialRestrictions() {
        return this.anyClamps;
    }

    private TreeModel validateTreeModel(List<RestrictedPartials> list) {
        TreeModel treeModel = list.get(0).getTreeModel();
        for (RestrictedPartials restrictedPartials : list) {
            if (restrictedPartials.getTreeModel() == treeModel) continue;
            throw new IllegalArgumentException("All tree models must be the same");
        }
        return treeModel;
    }

    private void addRestrictedPartials(RestrictedPartials restrictedPartials) {
        if (this.clampList == null) {
            this.clampList = new HashMap<BitSet, RestrictedPartials>();
        }
        this.clampList.put(restrictedPartials.getTipBitSet(), restrictedPartials);
        this.addModel(restrictedPartials);
        System.err.println("Added a CLAMP!");
    }

    private void setupRestrictedPartials() {
        for (RestrictedPartials restrictedPartials : this.clampList.values()) {
            int n = restrictedPartials.getIndex();
            double[] dArray = restrictedPartials.getRestrictedPartials();
            ContinuousDiffusionIntegrator continuousDiffusionIntegrator = null;
            continuousDiffusionIntegrator.setPostOrderPartial(n, dArray);
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            if (object instanceof TreeChangedEvent) {
                TreeChangedEvent treeChangedEvent = (TreeChangedEvent)object;
                if (treeChangedEvent.isTreeChanged()) {
                    this.updateTreeMapping = true;
                } else if (treeChangedEvent.isNodeChanged()) {
                    this.updateTreeMapping = true;
                }
            }
        } else if (model instanceof RestrictedPartials) {
            this.updateRestrictedPartials = true;
        } else {
            throw new RuntimeException("Unknown model");
        }
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.updateTreeMapping = true;
        this.updateRestrictedPartials = true;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    public void setupClamps() {
        if (this.nodeToClampMap == null) {
            this.nodeToClampMap = new HashMap<NodeRef, RestrictedPartials>();
        }
        this.nodeToClampMap.clear();
        this.recursiveSetupClamp(this.treeModel, this.treeModel.getRoot(), new BitSet());
        this.anyClamps = this.nodeToClampMap.size() > 0;
    }

    private void recursiveSetupClamp(Tree tree, NodeRef nodeRef, BitSet bitSet) {
        if (tree.isExternal(nodeRef)) {
            bitSet.set(nodeRef.getNumber());
        } else {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                BitSet bitSet2 = new BitSet();
                this.recursiveSetupClamp(tree, nodeRef2, bitSet2);
                bitSet.or(bitSet2);
            }
            if (this.clampList.containsKey(bitSet)) {
                RestrictedPartials restrictedPartials = this.clampList.get(bitSet);
                restrictedPartials.setNode(nodeRef);
                this.nodeToClampMap.put(nodeRef, restrictedPartials);
            }
        }
    }
}

