/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.stuff;

import dr.evolution.alignment.PatternList;
import dr.evolution.tree.Tree;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.branchmodel.HomogeneousBranchModel;
import dr.evomodel.branchmodel.lineagespecific.CountableRealizationsParameter;
import dr.evomodel.siteratemodel.GammaSiteRateModel;
import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.stuff.HDPPolyaUrn;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.math.MathException;

public class HDPDataSquashingOperator
extends SimpleMCMCOperator {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_DIST = false;
    private static final boolean DEBUG_NEW = true;
    private boolean newCatMethodOne = true;
    private boolean newCatMethodTwo = false;
    private HDPPolyaUrn hdp;
    private PatternList patternList;
    private boolean orderOneAdditions = true;
    public static final double ACCURACY_THRESHOLD = 1.0E-12;
    private int realizationCount;
    private int mhSteps;
    private int uniquePatternCount;
    private Parameter groupAssignments;
    private Parameter categoriesParameter;
    private CountableRealizationsParameter allParameters;
    private CompoundParameter uniquelyRealizedParameters;
    private CompoundParameter tableCounts;
    private CompoundParameter stickProportions;
    private List<Parameter> massParameterList;
    private Parameter commonBaseDistMass;
    private List<ParametricMultivariateDistributionModel> commonBaseDistBaseDist;
    private TreeDataLikelihood tdl;
    private CompoundLikelihood cl;
    private int order;
    private double epsilon;
    private double sampleProportion;
    private boolean isIHMM;
    private Parameter currentGroupAssignments;
    private Parameter currentCategoriesParameter;
    private CompoundParameter currentUniquelyRealizedParameters;
    private CompoundParameter currentTableCounts;
    private int[] sitesStillNeedingUpdate;
    private int numSitesStillNeedingUpdate;
    private boolean cyclical;
    private int distMethod;
    private int fixedNumber;
    private boolean strictCutoff;
    private int parameterDimension;
    private int maxNewCat;
    private boolean old;
    private List<SiteRateModel> siteRateModelList;
    private Tree treeModel;

    public HDPDataSquashingOperator(HDPPolyaUrn hDPPolyaUrn, TreeDataLikelihood treeDataLikelihood, CompoundLikelihood compoundLikelihood, List<SiteRateModel> list, Tree tree, PatternList patternList, int n, double d, boolean bl, int n2, double d2, double d3, int n3, boolean bl2, int n4, boolean bl3) {
        int n5;
        this.old = bl3;
        this.hdp = hDPPolyaUrn;
        this.groupAssignments = hDPPolyaUrn.getGroupAssignments();
        this.realizationCount = this.groupAssignments.getDimension();
        this.categoriesParameter = hDPPolyaUrn.getCategoriesParameter();
        this.tableCounts = hDPPolyaUrn.getTableCounts();
        this.stickProportions = hDPPolyaUrn.getStickProportions();
        this.uniquelyRealizedParameters = hDPPolyaUrn.getUniquelyRealizedParameters();
        this.allParameters = hDPPolyaUrn.getAllParameters();
        this.massParameterList = hDPPolyaUrn.getMassParameterList();
        this.commonBaseDistMass = hDPPolyaUrn.getCommonBaseDistMass();
        this.commonBaseDistBaseDist = hDPPolyaUrn.getCommonBaseDistBaseDist();
        this.order = hDPPolyaUrn.getOrder();
        this.isIHMM = hDPPolyaUrn.isIHMM();
        this.sampleProportion = d3;
        this.epsilon = d2;
        this.distMethod = n2;
        this.fixedNumber = n3;
        this.cyclical = bl;
        this.strictCutoff = bl2;
        this.tdl = treeDataLikelihood;
        this.cl = compoundLikelihood;
        this.siteRateModelList = list;
        this.treeModel = tree;
        this.patternList = patternList;
        this.uniquePatternCount = patternList.getPatternCount();
        this.mhSteps = n;
        this.currentGroupAssignments = new Parameter.Default(this.groupAssignments.getParameterValues());
        this.currentCategoriesParameter = new Parameter.Default(this.categoriesParameter.getParameterValues());
        this.currentUniquelyRealizedParameters = new CompoundParameter("current");
        for (n5 = 0; n5 < this.uniquelyRealizedParameters.getParameterCount(); ++n5) {
            this.currentUniquelyRealizedParameters.addParameter(new Parameter.Default(this.uniquelyRealizedParameters.getParameter(n5).getParameterValues()));
        }
        this.currentTableCounts = new CompoundParameter("currentTableCounts");
        for (n5 = 0; n5 < hDPPolyaUrn.maxGroupCount; ++n5) {
            this.currentTableCounts.addParameter(new Parameter.Default(this.tableCounts.getParameter(n5).getParameterValues()));
        }
        this.sitesStillNeedingUpdate = new int[this.realizationCount];
        if (bl) {
            for (n5 = 0; n5 < this.realizationCount; ++n5) {
                this.sitesStillNeedingUpdate[n5] = 1;
            }
        }
        this.numSitesStillNeedingUpdate = this.realizationCount;
        this.parameterDimension = this.uniquelyRealizedParameters.getParameter(0).getSize();
        this.maxNewCat = n4;
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        double d = 0.0;
        try {
            d = this.doOp();
        }
        catch (MathException mathException) {
            mathException.printStackTrace();
        }
        return d;
    }

    private double doOp() throws MathException {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        double[] dArray;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        for (n14 = 0; n14 < this.categoriesParameter.getSize(); ++n14) {
            this.currentGroupAssignments.setParameterValue(n14, this.groupAssignments.getParameterValue(n14));
            this.currentCategoriesParameter.setParameterValue(n14, this.categoriesParameter.getParameterValue(n14));
        }
        if (this.uniquelyRealizedParameters.getParameterCount() != this.hdp.maxCategoryCount) {
            throw new RuntimeException("uniquelyRealizedParameters should have same number of parametersas maxCategoryCount!");
        }
        for (n14 = 0; n14 < this.uniquelyRealizedParameters.getParameterCount(); ++n14) {
            for (n13 = 0; n13 < this.uniquelyRealizedParameters.getParameter(n14).getSize(); ++n13) {
                this.currentUniquelyRealizedParameters.getParameter(n14).setParameterValue(n13, this.uniquelyRealizedParameters.getParameter(n14).getParameterValue(n13));
            }
        }
        for (n14 = 0; n14 < this.hdp.maxGroupCount; ++n14) {
            for (n13 = 0; n13 < this.tableCounts.getParameter(n14).getSize(); ++n13) {
                this.currentTableCounts.getParameter(n14).setParameterValue(n13, this.tableCounts.getParameter(n14).getParameterValue(n13));
            }
        }
        int[][] nArray = new int[this.hdp.maxGroupCount][this.currentUniquelyRealizedParameters.getParameterCount()];
        for (n13 = 0; n13 < this.realizationCount; ++n13) {
            int n15 = (int)this.currentGroupAssignments.getParameterValue(n13);
            int n16 = (int)this.currentCategoriesParameter.getParameterValue(n13);
            int[] nArray2 = nArray[n15];
            int n17 = n16;
            nArray2[n17] = nArray2[n17] + 1;
        }
        n13 = 0;
        int[] nArray3 = new int[this.currentUniquelyRealizedParameters.getParameterCount()];
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.hdp.maxCategoryCount);
        int[] nArray4 = new int[this.hdp.maxCategoryCount];
        double[] dArray2 = new double[this.hdp.maxCategoryCount + 1];
        dArray2[dArray2.length - 1] = 1.0;
        for (int i = 0; i < nArray[0].length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                nArray3[i] = nArray3[i] + nArray[j][i];
            }
            if (nArray3[i] > 0) {
                ++n13;
                nArray4[i] = 1;
                dArray2[i] = this.stickProportions.getParameter(i).getParameterValue(0) * dArray2[dArray2.length - 1];
                dArray2[dArray2.length - 1] = (1.0 - this.stickProportions.getParameter(i).getParameterValue(0)) * dArray2[dArray2.length - 1];
                continue;
            }
            arrayList.add(i);
            nArray4[i] = 0;
        }
        double d = 0.0;
        for (int i = 0; i < this.hdp.maxCategoryCount + 1; ++i) {
            d += dArray2[i];
        }
        if (Math.abs(d - 1.0) > 1.0E-12) {
            throw new RuntimeException("common base dist weights must sum to 1");
        }
        if (arrayList.size() < this.maxNewCat) {
            throw new RuntimeException("There are not enough unoccupied categories");
        }
        int[] nArray5 = new int[this.hdp.maxGroupCount];
        for (int i = 0; i < this.hdp.maxGroupCount; ++i) {
            for (n12 = 0; n12 < n13; ++n12) {
                nArray5[i] = nArray5[i] + nArray[i][n12];
            }
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(0);
        n12 = 0;
        if (this.cyclical) {
            for (n11 = 0; n11 < this.realizationCount; ++n11) {
                if (this.sitesStillNeedingUpdate[n11] != 1) continue;
                arrayList2.add(n11);
            }
        } else {
            for (n11 = 0; n11 < this.realizationCount; ++n11) {
                arrayList2.add(n11);
            }
        }
        if (arrayList2.size() == 0) {
            for (n11 = 0; n11 < this.realizationCount; ++n11) {
                arrayList2.add(n11);
            }
        }
        n11 = MathUtils.nextInt(arrayList2.size());
        int n18 = (Integer)arrayList2.get(n11);
        int[] nArray6 = new int[this.hdp.maxCategoryCount];
        int n19 = 0;
        for (n10 = 0; n10 < this.cl.getLikelihoodCount() && ((TreeDataLikelihood)this.cl.getLikelihood(n10)).getDataLikelihoodDelegate() != null; ++n10) {
            ++n19;
        }
        if (this.old) {
            n10 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                int n20;
                if (n10 < this.maxNewCat) {
                    nArray6[((Integer)arrayList.get((int)i)).intValue()] = 1;
                }
                double[] dArray3 = new double[this.parameterDimension];
                int n21 = 0;
                for (n20 = 0; n20 < this.commonBaseDistBaseDist.size(); ++n20) {
                    dArray = this.commonBaseDistBaseDist.get(n20).nextRandom();
                    for (int j = 0; j < dArray.length; ++j) {
                        dArray3[n21] = dArray[j];
                        ++n21;
                    }
                }
                for (n20 = 0; n20 < this.parameterDimension; ++n20) {
                    this.uniquelyRealizedParameters.getParameter((Integer)arrayList.get(i)).setParameterValue(n20, dArray3[n20]);
                }
                ++n10;
            }
            this.tdl.makeDirty();
        } else {
            for (n10 = 0; n10 < this.maxNewCat; ++n10) {
                Object object2;
                int n22;
                nArray6[((Integer)arrayList.get((int)n10)).intValue()] = 1;
                double[] dArray4 = new double[this.parameterDimension];
                int n23 = 0;
                for (n22 = 0; n22 < this.commonBaseDistBaseDist.size(); ++n22) {
                    object2 = this.commonBaseDistBaseDist.get(n22).nextRandom();
                    for (int i = 0; i < ((double[])object2).length; ++i) {
                        dArray4[n23] = object2[i];
                        ++n23;
                    }
                }
                for (n22 = 0; n22 < this.parameterDimension; ++n22) {
                    this.uniquelyRealizedParameters.getParameter((Integer)arrayList.get(n10)).setParameterValue(n22, dArray4[n22]);
                }
                if ((Integer)arrayList.get(n10) >= n19) {
                    if ((Integer)arrayList.get(n10) > n19) {
                        throw new RuntimeException("next empty category should not be greater than currentNumDelegates");
                    }
                    System.out.println("New data likelihood delegate being created");
                    GammaSiteRateModel gammaSiteRateModel = (GammaSiteRateModel)this.siteRateModelList.get(n19);
                    object2 = new HomogeneousBranchModel(gammaSiteRateModel.getSubstitutionModel(), null);
                    Parameter.Default default_ = new Parameter.Default(1);
                    default_.setParameterValue(0, n19);
                    BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate = new BeagleDataLikelihoodDelegate(this.treeModel, this.patternList, (BranchModel)object2, gammaSiteRateModel, ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getUseAmbiguities(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getPreferGPU(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getRescalingScheme(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getDelayRescalingUntilUnderflow(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getPreOrderSettings(), this.categoriesParameter, default_);
                    ((TreeDataLikelihood)this.cl.getLikelihood((Integer)arrayList.get(n10))).setDataLikelihoodDelegate(beagleDataLikelihoodDelegate);
                    ++n19;
                }
                this.cl.getLikelihood((Integer)arrayList.get(n10)).makeDirty();
            }
        }
        double[] dArray5 = null;
        if (this.old) {
            dArray5 = this.tdl.getDataLikelihoodDelegate().getSiteLogLikelihoods();
        }
        double[][] dArray6 = null;
        dArray6 = this.old ? this.computeLogMassFunctions(arrayList2, n13, nArray, nArray5, this.currentGroupAssignments, dArray2, this.currentCategoriesParameter, dArray5) : this.computeLogMassFunctionsNew(arrayList2, n13, nArray, nArray5, this.currentGroupAssignments, dArray2, this.currentCategoriesParameter);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(arrayList2.size());
        if (this.distMethod == 1) {
            if (arrayList2.size() >= 2) {
                double d2 = this.computeThreshold(this.epsilon, this.sampleProportion, arrayList2, dArray6, n13);
                dArray = this.computeHellingerDist(dArray6, n18, arrayList2, n13);
                for (int i = 0; i < arrayList2.size(); ++i) {
                    if (!(dArray[i] <= d2)) continue;
                    arrayList3.add(arrayList2.get(i));
                    if (!this.cyclical || this.order != 0) continue;
                    this.sitesStillNeedingUpdate[arrayList2.get((int)i).intValue()] = 0;
                }
            } else {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    arrayList3.add(arrayList2.get(i));
                    if (!this.cyclical || this.order != 0) continue;
                    this.sitesStillNeedingUpdate[arrayList2.get((int)i).intValue()] = 0;
                }
            }
        }
        if (this.distMethod == 2) {
            int n24 = (int)(this.epsilon * (double)arrayList2.size());
            if (this.fixedNumber > 0) {
                n24 = this.fixedNumber;
                if (this.fixedNumber > arrayList2.size()) {
                    n24 = arrayList2.size();
                }
            }
            if (n24 == 0) {
                n24 = arrayList2.size();
            }
            if (n13 > 1) {
                int n25;
                double[] dArray7 = this.computeHellingerDist(dArray6, n18, arrayList2, n13);
                dArray = new double[dArray7.length];
                System.arraycopy(dArray7, 0, dArray, 0, dArray7.length);
                Arrays.sort(dArray);
                double d3 = dArray[n24 - 1];
                if (this.fixedNumber == 1) {
                    arrayList3.add(n18);
                } else if (this.strictCutoff) {
                    for (n25 = 0; n25 < arrayList2.size(); ++n25) {
                        if (!(dArray7[n25] <= d3) || arrayList3.size() >= n24) continue;
                        arrayList3.add(arrayList2.get(n25));
                        if (!this.cyclical || this.order != 0) continue;
                        this.sitesStillNeedingUpdate[arrayList2.get((int)n25).intValue()] = 0;
                    }
                } else {
                    if (d3 < 0.0) {
                        d3 = 0.0;
                    }
                    for (n25 = 0; n25 < arrayList2.size(); ++n25) {
                        if (!(dArray7[n25] <= d3)) continue;
                        arrayList3.add(arrayList2.get(n25));
                        if (!this.cyclical || this.order != 0) continue;
                        this.sitesStillNeedingUpdate[arrayList2.get((int)n25).intValue()] = 0;
                    }
                }
            } else {
                ArrayList<Integer> arrayList4 = new ArrayList<Integer>(arrayList2.size());
                for (int i = 0; i < arrayList2.size(); ++i) {
                    arrayList4.add(i);
                }
                Random random = new Random(MathUtils.getSeed());
                Collections.shuffle(arrayList4, random);
                if (this.fixedNumber == 1) {
                    arrayList3.add(n18);
                } else {
                    for (int i = 0; i < n24; ++i) {
                        arrayList3.add((Integer)arrayList4.get(i));
                        if (!this.cyclical || this.order != 0) continue;
                        this.sitesStillNeedingUpdate[((Integer)arrayList4.get((int)i)).intValue()] = 0;
                    }
                }
            }
        }
        if (arrayList3.size() == 0) {
            System.err.println("0 sites in update");
        }
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>(0);
        if (this.order == 1) {
            if (this.cyclical) {
                for (int i = 0; i < arrayList3.size(); ++i) {
                    if (Math.abs((Integer)arrayList3.get(i) - n18) % 2 != 0) continue;
                    arrayList5.add((Integer)arrayList3.get(i));
                    this.sitesStillNeedingUpdate[((Integer)arrayList3.get((int)i)).intValue()] = 0;
                }
            } else {
                for (int i = 0; i < arrayList3.size(); ++i) {
                    if (Math.abs((Integer)arrayList3.get(i) - n18) % 2 != 0) continue;
                    arrayList5.add((Integer)arrayList3.get(i));
                }
            }
        } else {
            arrayList5 = arrayList3;
        }
        if (this.cyclical) {
            this.numSitesStillNeedingUpdate -= arrayList5.size();
        }
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>(0);
        if (this.order == 1) {
            for (int i = 0; i < arrayList5.size(); ++i) {
                arrayList6.add((Integer)arrayList5.get(i));
                int n26 = (Integer)arrayList5.get(i) + 1;
                if (n26 >= this.realizationCount) continue;
                arrayList6.add(n26);
            }
        } else {
            arrayList6 = arrayList5;
        }
        double[] dArray8 = new double[this.hdp.maxCategoryCount];
        if (n13 + this.maxNewCat > this.hdp.maxCategoryCount) {
            throw new RuntimeException("There are not enough empty categories");
        }
        double[][] dArray9 = new double[this.hdp.maxGroupCount][this.hdp.maxCategoryCount];
        double[][] dArray10 = new double[this.hdp.maxGroupCount][this.hdp.maxCategoryCount];
        double[] dArray11 = new double[this.hdp.maxGroupCount];
        int n27 = (int)this.currentGroupAssignments.getParameterValue(n18);
        for (n9 = 0; n9 < this.realizationCount; ++n9) {
            int n28 = (int)this.currentGroupAssignments.getParameterValue(n9);
            int n29 = (int)this.currentCategoriesParameter.getParameterValue(n9);
            if (arrayList5.contains(n9)) continue;
            double[] dArray12 = dArray9[n28];
            int n30 = n29;
            dArray12[n30] = dArray12[n30] + 1.0;
            if (arrayList6.contains(n9)) continue;
            double[] dArray13 = dArray10[n28];
            int n31 = n29;
            dArray13[n31] = dArray13[n31] + 1.0;
            int n32 = n28;
            dArray11[n32] = dArray11[n32] + 1.0;
        }
        double[] dArray14 = new double[this.hdp.maxCategoryCount];
        double d4 = this.massParameterList.get(0).getParameterValue(0);
        double d5 = this.commonBaseDistMass.getParameterValue(0);
        for (int i = 0; i < this.hdp.maxCategoryCount; ++i) {
            int n33;
            if (nArray6[i] == 1) {
                if (this.old) {
                    n9 = this.uniquePatternCount * i + this.patternList.getPatternIndex(n18);
                    dArray8[i] = dArray5[n9];
                } else {
                    dArray8[i] = ((TreeDataLikelihood)this.cl.getLikelihood(i)).getDataLikelihoodDelegate().getSiteLogLikelihoods()[this.patternList.getPatternIndex(n18)];
                }
                if (dArray8[i] == Double.POSITIVE_INFINITY || Double.isNaN(dArray8[i])) {
                    dArray8[i] = Double.NEGATIVE_INFINITY;
                }
                dArray8[i] = dArray8[i] + Math.log(d4 * dArray2[this.hdp.maxCategoryCount] / (double)this.maxNewCat / (d4 + dArray11[n27]));
                if (this.order != 1 || !this.orderOneAdditions || n18 + 1 >= this.realizationCount) continue;
                n33 = (int)this.currentCategoriesParameter.getParameterValue(n18 + 1);
                dArray8[i] = dArray8[i] + Math.log(dArray2[n33]);
                continue;
            }
            if (nArray4[i] == 1) {
                int n34;
                int n35;
                if (this.old) {
                    n9 = this.uniquePatternCount * i + this.patternList.getPatternIndex(n18);
                    dArray8[i] = dArray5[n9];
                } else {
                    dArray8[i] = ((TreeDataLikelihood)this.cl.getLikelihood(i)).getDataLikelihoodDelegate().getSiteLogLikelihoods()[this.patternList.getPatternIndex(n18)];
                }
                dArray8[i] = dArray8[i] + Math.log((dArray10[n27][i] + d4 * dArray2[i]) / (d4 + dArray11[n27]));
                if (this.order != 1 || !this.orderOneAdditions || n18 + 1 >= this.realizationCount) continue;
                int n36 = 1 + i;
                n33 = 0;
                n8 = 0;
                if (n27 == n36) {
                    n33 = 1;
                }
                if ((n35 = i) == (n34 = (int)this.currentCategoriesParameter.getParameterValue(n18 + 1))) {
                    n8 = 1;
                }
                dArray8[i] = dArray8[i] + Math.log((d4 * dArray2[n34] + dArray10[n36][n34] + (double)(n33 * n8)) / (d4 + dArray11[n36] + (double)n33));
                continue;
            }
            dArray8[i] = Double.NEGATIVE_INFINITY;
        }
        double d6 = dArray8[0];
        for (n8 = 1; n8 < dArray8.length; ++n8) {
            if (!(dArray8[n8] > d6)) continue;
            d6 = dArray8[n8];
        }
        double[] dArray15 = new double[dArray8.length];
        double d7 = 0.0;
        for (n7 = 0; n7 < dArray15.length; ++n7) {
            dArray15[n7] = Math.exp(dArray8[n7] - d6);
            d7 += dArray15[n7];
        }
        for (n7 = 0; n7 < dArray15.length; ++n7) {
            dArray15[n7] = dArray15[n7] / d7;
        }
        int[] nArray7 = new int[arrayList5.size()];
        for (int i = 0; i < nArray7.length; ++i) {
            nArray7[i] = MathUtils.randomChoicePDF(dArray15);
        }
        double d8 = 0.0;
        int[] nArray8 = new int[this.hdp.maxCategoryCount];
        for (n6 = 0; n6 < nArray7.length; ++n6) {
            if (nArray6[nArray7[n6]] == 1) {
                nArray8[nArray7[n6]] = 1;
            }
            this.categoriesParameter.setParameterValue((Integer)arrayList5.get(n6), nArray7[n6]);
            d8 -= Math.log(dArray15[nArray7[n6]]);
        }
        for (n6 = 0; n6 < this.hdp.maxCategoryCount; ++n6) {
            if (nArray8[n6] != 1) continue;
            d8 -= this.hdp.getLogDensity(this.uniquelyRealizedParameters.getParameter(n6), 0);
        }
        if (this.order == 1) {
            for (n6 = 0; n6 < arrayList5.size(); ++n6) {
                if ((Integer)arrayList5.get(n6) + 1 >= this.realizationCount) continue;
                int n37 = (int)this.categoriesParameter.getParameterValue((Integer)arrayList5.get(n6));
                this.hdp.setGroup(this.groupAssignments, (Integer)arrayList5.get(n6) + 1, n37);
            }
        }
        int[][] nArray9 = new int[this.hdp.maxGroupCount][this.uniquelyRealizedParameters.getParameterCount()];
        int[] nArray10 = new int[this.uniquelyRealizedParameters.getParameterCount()];
        for (n5 = 0; n5 < this.realizationCount; ++n5) {
            int[] nArray11 = nArray9[(int)this.groupAssignments.getParameterValue(n5)];
            int n38 = (int)this.categoriesParameter.getParameterValue(n5);
            nArray11[n38] = nArray11[n38] + 1;
            int n39 = (int)this.categoriesParameter.getParameterValue(n5);
            nArray10[n39] = nArray10[n39] + 1;
        }
        for (n5 = 0; n5 < this.hdp.maxGroupCount; ++n5) {
            for (int i = 0; i < this.uniquelyRealizedParameters.getParameterCount(); ++i) {
                if (this.tableCounts.getParameter(n5).getParameterValue(i) > (double)nArray9[n5][i]) {
                    this.tableCounts.getParameter(n5).setParameterValue(i, nArray9[n5][i]);
                }
                if (nArray9[n5][i] <= 0 || this.tableCounts.getParameter(n5).getParameterValue(i) != 0.0) continue;
                this.tableCounts.getParameter(n5).setParameterValue(i, 1.0);
            }
        }
        double[] dArray16 = new double[this.hdp.maxCategoryCount + 1];
        dArray16[dArray16.length - 1] = 1.0;
        double d9 = 0.0;
        for (int i = 0; i < this.hdp.maxCategoryCount; ++i) {
            if (nArray10[i] == 0) {
                this.stickProportions.getParameter(i).setParameterValue(0, 0.0);
            } else {
                if (nArray8[i] == 1) {
                    double d10 = MathUtils.nextBeta(1.0, d5);
                    while (d10 == 1.0 || d10 == 0.0) {
                        d10 = MathUtils.nextBeta(1.0, d5);
                    }
                    this.stickProportions.getParameter(i).setParameterValue(0, d10);
                } else if (this.stickProportions.getParameter(i).getParameterValue(0) == 0.0) {
                    throw new RuntimeException("stick proportion corresponding to occupied category should not be zero");
                }
                dArray16[i] = this.stickProportions.getParameter(i).getParameterValue(0) * dArray16[dArray16.length - 1];
                dArray16[dArray16.length - 1] = (1.0 - this.stickProportions.getParameter(i).getParameterValue(0)) * dArray16[dArray16.length - 1];
            }
            d9 += dArray16[i];
        }
        if (Math.abs((d9 += dArray16[dArray16.length - 1]) - 1.0) > 1.0E-12) {
            throw new RuntimeException("commonBaseDistWeights must sum to 1");
        }
        int[][] nArray12 = new int[this.hdp.maxGroupCount][this.uniquelyRealizedParameters.getParameterCount()];
        double[] dArray17 = new double[this.hdp.maxCategoryCount];
        double[] dArray18 = new double[this.hdp.maxCategoryCount];
        double[][] dArray19 = new double[this.hdp.maxGroupCount][this.hdp.maxCategoryCount];
        double[][] dArray20 = new double[this.hdp.maxGroupCount][this.hdp.maxCategoryCount];
        double[] dArray21 = new double[this.hdp.maxGroupCount];
        int n40 = (int)this.groupAssignments.getParameterValue(n18);
        for (n4 = 0; n4 < this.realizationCount; ++n4) {
            int n41 = (int)this.groupAssignments.getParameterValue(n4);
            int n42 = (int)this.categoriesParameter.getParameterValue(n4);
            int[] nArray13 = nArray12[n41];
            int n43 = n42;
            nArray13[n43] = nArray13[n43] + 1;
            if (arrayList5.contains(n4)) continue;
            double[] dArray22 = dArray19[n41];
            int n44 = n42;
            dArray22[n44] = dArray22[n44] + 1.0;
            if (arrayList6.contains(n4)) continue;
            double[] dArray23 = dArray20[n41];
            int n45 = n42;
            dArray23[n45] = dArray23[n45] + 1.0;
            int n46 = n41;
            dArray21[n46] = dArray21[n46] + 1.0;
        }
        n4 = 0;
        int[] nArray14 = new int[this.uniquelyRealizedParameters.getParameterCount()];
        int[] nArray15 = new int[this.hdp.maxCategoryCount];
        ArrayList<Integer> arrayList7 = new ArrayList<Integer>(this.hdp.maxCategoryCount);
        for (int i = 0; i < nArray12[0].length; ++i) {
            for (int j = 0; j < nArray12.length; ++j) {
                nArray14[i] = nArray14[i] + nArray12[j][i];
            }
            if (nArray14[i] > 0) {
                ++n4;
                nArray15[i] = 1;
                continue;
            }
            arrayList7.add(i);
        }
        int[] nArray16 = new int[this.hdp.maxCategoryCount];
        int[] nArray17 = new int[this.hdp.maxCategoryCount];
        int n47 = 0;
        for (n3 = 0; n3 < this.hdp.maxCategoryCount; ++n3) {
            if (nArray4[n3] != 1 || nArray15[n3] == 1) continue;
            nArray16[n3] = 1;
            nArray17[n3] = 1;
            ++n47;
        }
        if (n47 < this.maxNewCat && this.maxNewCat <= arrayList7.size()) {
            n3 = this.maxNewCat - n47;
            for (n2 = 0; n2 < n3; ++n2) {
                int n48;
                if (nArray17[(Integer)arrayList7.get(n2)] != 1) {
                    nArray17[((Integer)arrayList7.get((int)n2)).intValue()] = 1;
                }
                double[] dArray24 = new double[this.parameterDimension];
                n = 0;
                for (n48 = 0; n48 < this.commonBaseDistBaseDist.size(); ++n48) {
                    object = this.commonBaseDistBaseDist.get(n48).nextRandom();
                    for (int i = 0; i < ((double[])object).length; ++i) {
                        dArray24[n] = object[i];
                        ++n;
                    }
                }
                for (n48 = 0; n48 < this.parameterDimension; ++n48) {
                    this.uniquelyRealizedParameters.getParameter((Integer)arrayList7.get(n2)).setParameterValue(n48, dArray24[n48]);
                }
                if ((Integer)arrayList7.get(n2) >= n19) {
                    if ((Integer)arrayList7.get(n2) > n19) {
                        throw new RuntimeException("next empty category should not be greater than currentNumDelegates");
                    }
                    System.out.println("New data likelihood delegate being created");
                    GammaSiteRateModel gammaSiteRateModel = (GammaSiteRateModel)this.siteRateModelList.get(n19);
                    object = new HomogeneousBranchModel(gammaSiteRateModel.getSubstitutionModel(), null);
                    Parameter.Default default_ = new Parameter.Default(1);
                    default_.setParameterValue(0, n19);
                    BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate = new BeagleDataLikelihoodDelegate(this.treeModel, this.patternList, (BranchModel)object, gammaSiteRateModel, ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getUseAmbiguities(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getPreferGPU(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getRescalingScheme(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getDelayRescalingUntilUnderflow(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getPreOrderSettings(), this.categoriesParameter, default_);
                    ((TreeDataLikelihood)this.cl.getLikelihood((Integer)arrayList7.get(n2))).setDataLikelihoodDelegate(beagleDataLikelihoodDelegate);
                    ++n19;
                    continue;
                }
                this.cl.getLikelihood((Integer)arrayList7.get(n2)).makeDirty();
            }
        }
        if (n47 > this.maxNewCat || this.maxNewCat > arrayList7.size()) {
            d8 = Double.NEGATIVE_INFINITY;
        } else {
            int n49;
            int n50;
            for (n3 = 0; n3 < this.hdp.maxCategoryCount; ++n3) {
                if (nArray17[n3] == 1) {
                    if (this.old) {
                        n9 = this.uniquePatternCount * n3 + this.patternList.getPatternIndex(n18);
                        dArray18[n3] = dArray5[n9];
                    } else {
                        dArray18[n3] = ((TreeDataLikelihood)this.cl.getLikelihood(n3)).getDataLikelihoodDelegate().getSiteLogLikelihoods()[this.patternList.getPatternIndex(n18)];
                    }
                    dArray18[n3] = dArray18[n3] + Math.log(d4 * dArray16[this.hdp.maxCategoryCount] / (double)this.maxNewCat / (d4 + dArray21[n40]));
                    if (this.order != 1 || !this.orderOneAdditions || n18 + 1 >= this.realizationCount) continue;
                    n2 = (int)this.categoriesParameter.getParameterValue(n18 + 1);
                    dArray18[n3] = dArray18[n3] + Math.log(dArray16[n2]);
                    continue;
                }
                if (nArray15[n3] == 1) {
                    int n51;
                    if (this.old) {
                        n9 = this.uniquePatternCount * n3 + this.patternList.getPatternIndex(n18);
                        dArray18[n3] = dArray5[n9];
                    } else {
                        dArray18[n3] = ((TreeDataLikelihood)this.cl.getLikelihood(n3)).getDataLikelihoodDelegate().getSiteLogLikelihoods()[this.patternList.getPatternIndex(n18)];
                    }
                    dArray18[n3] = dArray18[n3] + Math.log((dArray20[n40][n3] + d4 * dArray16[n3]) / (d4 + dArray21[n40]));
                    if (this.order != 1 || !this.orderOneAdditions || n18 + 1 >= this.realizationCount) continue;
                    int n52 = n3 + 1;
                    n2 = 0;
                    int n53 = 0;
                    if (n40 == n52) {
                        n2 = 1;
                    }
                    if ((n = n3) == (n51 = (int)this.categoriesParameter.getParameterValue(n18 + 1))) {
                        n53 = 1;
                    }
                    dArray18[n3] = dArray18[n3] + Math.log((d4 * dArray16[n51] + dArray20[n52][n51] + (double)(n2 * n53)) / (d4 + dArray21[n52] + (double)n2));
                    continue;
                }
                dArray18[n3] = Double.NEGATIVE_INFINITY;
            }
            double d11 = dArray18[0];
            for (int i = 1; i < dArray18.length; ++i) {
                if (!(dArray18[i] > d11)) continue;
                d11 = dArray18[i];
            }
            double d12 = 0.0;
            for (n50 = 0; n50 < dArray17.length; ++n50) {
                dArray17[n50] = Math.exp(dArray18[n50] - d11);
                d12 += dArray17[n50];
            }
            for (n50 = 0; n50 < dArray17.length; ++n50) {
                dArray17[n50] = dArray17[n50] / d12;
            }
            object = new int[this.hdp.maxCategoryCount];
            for (n49 = 0; n49 < arrayList5.size(); ++n49) {
                n50 = (int)this.currentCategoriesParameter.getParameterValue((Integer)arrayList5.get(n49));
                d8 += Math.log(dArray17[n50]);
                if (nArray16[n50] != 1) continue;
                object[n50] = 1.0;
            }
            for (n49 = 0; n49 < this.hdp.maxCategoryCount; ++n49) {
                if (nArray16[n49] != 1) continue;
                if (object[n49] != true) {
                    throw new RuntimeException("problem in keeping track of current categories that are unoccupied in proposal");
                }
                d8 += this.hdp.getLogDensity(this.uniquelyRealizedParameters.getParameter(n49), 0);
            }
        }
        if (this.cyclical && this.numSitesStillNeedingUpdate == 0) {
            Arrays.fill(this.sitesStillNeedingUpdate, 1);
            this.numSitesStillNeedingUpdate = this.sitesStillNeedingUpdate.length;
        }
        return d8;
    }

    private int drawRandomElementFromSet(ArrayList<Integer> arrayList) {
        int n = MathUtils.nextInt(arrayList.size());
        return arrayList.get(n);
    }

    private double[] computeHellingerDist(double[][] dArray, int n, ArrayList<Integer> arrayList, int n2) {
        double[] dArray2 = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            if (n == arrayList.get(i)) {
                dArray2[i] = 0.0;
                continue;
            }
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                d += Math.sqrt(Math.exp(dArray[n][j]) * Math.exp(dArray[arrayList.get(i)][j]));
            }
            dArray2[i] = 2.0 * (1.0 - d);
        }
        return dArray2;
    }

    private double[] getUnsortedHellingerDistances(double[][] dArray, ArrayList<Integer> arrayList, int n) {
        double[] dArray2 = new double[arrayList.size() * (arrayList.size() - 1) / 2];
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = i + 1; j < arrayList.size(); ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += Math.sqrt(Math.exp(dArray[arrayList.get(i)][k]) * Math.exp(dArray[arrayList.get(j)][k]));
                }
                dArray2[n2] = 2.0 * (1.0 - d);
                ++n2;
            }
        }
        return dArray2;
    }

    private double[][] computeLogMassFunctions(ArrayList<Integer> arrayList, int n, int[][] nArray, int[] nArray2, Parameter parameter, double[] dArray, Parameter parameter2, double[] dArray2) {
        double[][] dArray3 = new double[this.realizationCount][n];
        double d = this.massParameterList.get(0).getParameterValue(0);
        for (int i = 0; i < arrayList.size(); ++i) {
            int n2;
            double d2 = 0.0;
            int n3 = 0;
            for (int j = 0; j < this.hdp.maxCategoryCount; ++j) {
                int n4 = (int)parameter.getParameterValue(arrayList.get(i));
                if (nArray[n4][j] == 0) continue;
                n2 = this.uniquePatternCount * j + this.patternList.getPatternIndex(arrayList.get(i));
                dArray3[arrayList.get((int)i).intValue()][n3] = dArray2[n2];
                dArray3[arrayList.get((int)i).intValue()][n3] = dArray3[arrayList.get(i)][n3] + Math.log(((double)nArray[n4][j] + d * dArray[j]) / (d + (double)nArray2[n4]));
                if (this.order == 1 && this.orderOneAdditions && arrayList.get(i) + 1 < this.realizationCount) {
                    int n5;
                    int n6;
                    int n7 = j + 1;
                    int n8 = 0;
                    int n9 = 0;
                    if (n4 == n7) {
                        n8 = 1;
                    }
                    if ((n6 = j) == (n5 = (int)parameter2.getParameterValue(arrayList.get(i) + 1))) {
                        n9 = 1;
                    }
                    dArray3[arrayList.get((int)i).intValue()][n3] = dArray3[arrayList.get(i)][n3] + Math.log((d * dArray[n5] + (double)nArray[n7][n5] + (double)(n8 * n9)) / (d + (double)nArray2[n7] + (double)n8));
                }
                ++n3;
            }
            double d3 = dArray3[arrayList.get(i)][0];
            for (n2 = 1; n2 < n; ++n2) {
                if (!(dArray3[arrayList.get(i)][n2] > d3)) continue;
                d3 = dArray3[arrayList.get(i)][n2];
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray3[arrayList.get((int)i).intValue()][n2] = dArray3[arrayList.get(i)][n2] - d3;
                d2 += Math.exp(dArray3[arrayList.get(i)][n2]);
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray3[arrayList.get((int)i).intValue()][n2] = dArray3[arrayList.get(i)][n2] - Math.log(d2);
            }
        }
        return dArray3;
    }

    private double[][] computeLogMassFunctionsNew(ArrayList<Integer> arrayList, int n, int[][] nArray, int[] nArray2, Parameter parameter, double[] dArray, Parameter parameter2) {
        double[][] dArray2 = new double[this.realizationCount][n];
        double d = this.massParameterList.get(0).getParameterValue(0);
        for (int i = 0; i < arrayList.size(); ++i) {
            int n2;
            double d2 = 0.0;
            int n3 = 0;
            for (int j = 0; j < this.hdp.maxCategoryCount; ++j) {
                int n4 = (int)parameter.getParameterValue(arrayList.get(i));
                if (nArray[n4][j] == 0) continue;
                dArray2[arrayList.get((int)i).intValue()][n3] = ((TreeDataLikelihood)this.cl.getLikelihood(j)).getDataLikelihoodDelegate().getSiteLogLikelihoods()[this.patternList.getPatternIndex(arrayList.get(i))];
                dArray2[arrayList.get((int)i).intValue()][n3] = dArray2[arrayList.get(i)][n3] + Math.log(((double)nArray[n4][j] + d * dArray[j]) / (d + (double)nArray2[n4]));
                if (this.order == 1 && this.orderOneAdditions && arrayList.get(i) + 1 < this.realizationCount) {
                    int n5;
                    int n6;
                    n2 = j + 1;
                    int n7 = 0;
                    int n8 = 0;
                    if (n4 == n2) {
                        n7 = 1;
                    }
                    if ((n6 = j) == (n5 = (int)parameter2.getParameterValue(arrayList.get(i) + 1))) {
                        n8 = 1;
                    }
                    dArray2[arrayList.get((int)i).intValue()][n3] = dArray2[arrayList.get(i)][n3] + Math.log((d * dArray[n5] + (double)nArray[n2][n5] + (double)(n7 * n8)) / (d + (double)nArray2[n2] + (double)n7));
                }
                ++n3;
            }
            double d3 = dArray2[arrayList.get(i)][0];
            for (n2 = 1; n2 < n; ++n2) {
                if (!(dArray2[arrayList.get(i)][n2] > d3)) continue;
                d3 = dArray2[arrayList.get(i)][n2];
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray2[arrayList.get((int)i).intValue()][n2] = dArray2[arrayList.get(i)][n2] - d3;
                d2 += Math.exp(dArray2[arrayList.get(i)][n2]);
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray2[arrayList.get((int)i).intValue()][n2] = dArray2[arrayList.get(i)][n2] - Math.log(d2);
            }
        }
        return dArray2;
    }

    private double computeThreshold(double d, double d2, ArrayList<Integer> arrayList, double[][] dArray, int n) {
        double d3;
        int n2 = (int)(d2 * (double)arrayList.size());
        if (n2 < 2) {
            n2 = 2;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2.add(arrayList.get(i));
        }
        Random random = new Random(MathUtils.getSeed());
        Collections.shuffle(arrayList2, random);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList3.add((Integer)arrayList2.get(i));
        }
        double[] dArray2 = this.getUnsortedHellingerDistances(dArray, arrayList3, n);
        Arrays.sort(dArray2, 0, dArray2.length - 1);
        int n3 = (int)(d * (double)n2 * (double)(n2 - 1));
        if (n3 == 0) {
            n3 = 1;
        }
        if ((d3 = dArray2[n3 - 1]) < 0.0) {
            d3 = 0.0;
        }
        return d3;
    }

    @Override
    public String getOperatorName() {
        return "hdpDataSquashingOperator";
    }
}

