/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.NormalDistributionModel;
import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.RandomGenerator;

public class MomentDistributionModel
extends AbstractModelLikelihood
implements ParametricMultivariateDistributionModel,
RandomGenerator {
    private final Parameter mean;
    private final Parameter precision;
    private final Parameter cutoff;
    private NormalDistributionModel untruncated;
    private double sum;
    private boolean sumKnown;
    private boolean storedSumKnown;
    private double storedSum;
    private boolean untruncatedKnown;
    private boolean storedUntruncatedKnown;
    private NormalDistributionModel storedUntruncated;
    private Parameter data;

    public MomentDistributionModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4) {
        super(string);
        this.mean = parameter;
        this.precision = parameter2;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.addVariable(parameter2);
        this.cutoff = parameter3;
        if (parameter3 != null) {
            this.addVariable(parameter3);
            int n = parameter3.getBounds() != null ? parameter3.getBounds().getBoundsDimension() : parameter3.getDimension();
            parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, n));
        }
        this.addVariable(parameter4);
        this.data = parameter4;
        this.untruncated = new NormalDistributionModel(parameter, parameter2, true);
        this.sumKnown = false;
        this.untruncatedKnown = false;
    }

    public double logPdf(Parameter parameter) {
        this.checkDistribution();
        if (this.sumKnown) {
            return this.sum;
        }
        this.sum = 0.0;
        if (this.cutoff != null) {
            if (parameter.getDimension() != this.cutoff.getDimension()) {
                throw new RuntimeException("Incorrect number of cutoffs");
            }
            for (int i = 0; i < parameter.getDimension(); ++i) {
                if (Math.sqrt(this.cutoff.getParameterValue(i)) - 0.05 > Math.abs(parameter.getParameterValue(i)) && parameter.getParameterValue(i) != 0.0) {
                    return Double.NEGATIVE_INFINITY;
                }
                if (parameter.getParameterValue(i) == 0.0) {
                    this.sum += 0.0;
                    continue;
                }
                this.sum += this.untruncated.logPdf(parameter.getParameterValue(i)) + this.getNormalizingConstant(i);
            }
        } else {
            for (int i = 0; i < parameter.getDimension(); ++i) {
                this.sum += this.untruncated.logPdf(parameter.getParameterValue(i)) + 2.0 * StrictMath.log(Math.abs(parameter.getParameterValue(i))) + StrictMath.log(this.precision.getParameterValue(0));
            }
        }
        this.sumKnown = true;
        return this.sum;
    }

    public double getNormalizingConstant(int n) {
        return -Math.log(1.0 - (this.untruncated.cdf(Math.sqrt(this.cutoff.getParameterValue(n))) - this.untruncated.cdf(-Math.sqrt(this.cutoff.getParameterValue(n)))));
    }

    @Override
    public double logPdf(double[] dArray) {
        return 0.0;
    }

    public Parameter getCutoff() {
        return this.cutoff;
    }

    @Override
    public double[][] getScaleMatrix() {
        double[][] dArray = new double[1][1];
        dArray[0][0] = this.precision.getParameterValue(0);
        return dArray;
    }

    @Override
    public double[] getMean() {
        return this.mean.getParameterValues();
    }

    @Override
    public String getType() {
        return "Moment Distribution Model";
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.sumKnown = false;
        if (variable == this.mean || variable == this.precision) {
            this.untruncatedKnown = false;
        }
    }

    @Override
    protected void storeState() {
        this.storedSumKnown = this.sumKnown;
        this.storedSum = this.sum;
        this.storedUntruncated = this.untruncated;
        this.storedUntruncatedKnown = this.untruncatedKnown;
    }

    @Override
    protected void restoreState() {
        this.sumKnown = this.storedSumKnown;
        this.sum = this.storedSum;
        this.untruncated = this.storedUntruncated;
        this.untruncatedKnown = this.storedUntruncatedKnown;
    }

    @Override
    protected void acceptState() {
    }

    private NormalDistributionModel createNewDistribution() {
        return new NormalDistributionModel(this.mean, this.precision, true);
    }

    private void checkDistribution() {
        if (!this.untruncatedKnown) {
            this.untruncated = this.createNewDistribution();
            this.untruncatedKnown = true;
        }
    }

    @Override
    public double[] nextRandom() {
        return new double[0];
    }

    @Override
    public int getDimension() {
        return this.mean.getSize();
    }

    @Override
    public double logPdf(Object object) {
        if (object instanceof Parameter) {
            return this.logPdf((Parameter)object);
        }
        return 0.0;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        return this.logPdf(this.data);
    }

    @Override
    public void makeDirty() {
        this.sumKnown = false;
        this.untruncatedKnown = false;
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

