/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.evomodel.continuous.FullyConjugateMultivariateTraitLikelihood;
import dr.evomodel.continuous.TreeTraitNormalDistributionModel;
import dr.inference.distribution.AbstractDistributionLikelihood;
import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.CompoundSymmetricMatrix;
import dr.inference.model.DefaultModel;
import dr.inference.model.Likelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.ConstrainedDeterminantDistributionModel;
import dr.math.distributions.DirichletDistribution;
import dr.math.distributions.InverseWishartDistribution;
import dr.math.distributions.LKJCholeskyCorrelationDistribution;
import dr.math.distributions.LKJCorrelationDistribution;
import dr.math.distributions.LogNormalDistribution;
import dr.math.distributions.MultivariateDistribution;
import dr.math.distributions.MultivariateGammaDistribution;
import dr.math.distributions.MultivariateLogNormalDistribution;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.distributions.SphericalBetaDistribution;
import dr.math.distributions.TransformedMultivariateDistribution;
import dr.math.distributions.WishartDistribution;
import dr.util.Attribute;
import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.util.logging.Logger;

public class MultivariateDistributionLikelihood
extends AbstractDistributionLikelihood {
    public static final String MVN_PRIOR = "multivariateNormalPrior";
    public static final String MVN_MEAN = "meanParameter";
    public static final String MVN_PRECISION = "precisionParameter";
    public static final String MVN_CV = "coefficientOfVariation";
    public static final String WISHART_PRIOR = "multivariateWishartPrior";
    public static final String INV_WISHART_PRIOR = "multivariateInverseWishartPrior";
    public static final String DIRICHLET_PRIOR = "dirichletParameterPrior";
    public static final String SUM_TO_NUMBER_OF_ELEMENTS = "sumToNumberOfElements";
    public static final String DF = "df";
    public static final String SCALE_MATRIX = "scaleMatrix";
    public static final String MVGAMMA_PRIOR = "multivariateGammaPrior";
    public static final String MVGAMMA_SHAPE = "shapeParameter";
    public static final String MVGAMMA_SCALE = "scaleParameter";
    public static final String COUNTS = "countsParameter";
    public static final String NON_INFORMATIVE = "nonInformative";
    public static final String MULTIVARIATE_LIKELIHOOD = "multivariateDistributionLikelihood";
    public static final String DATA_AS_MATRIX = "dataAsMatrix";
    public static final String TREE_TRAIT = "treeTraitNormalDistributionLikelihood";
    public static final String TREE_TRAIT_NORMAL = "treeTraitNormalDistribution";
    public static final String ROOT_VALUE = "rootValue";
    public static final String CONDITION = "conditionOnRoot";
    public static final String LKJ_PRIOR = "LKJCorrelationPrior";
    public static final String LKJ_SHAPE = "shapeParameter";
    public static final String DIMENSION = "dimension";
    public static final String CHOLESKY = "cholesky";
    public static final String SPHERICAL_BETA_PRIOR = "sphericalBetaPrior";
    public static final String SPHERICAL_BETA_SHAPE = "shapeParameter";
    public static final String MV_LOG_NORMAL_PRIOR = "MVlogNormalPrior";
    public static final String DETERMINANT_PRIOR = "determinantPrior";
    public static final String DATA = "data";
    private final MultivariateDistribution distribution;
    private final Transform[] transforms;
    private Parameter parameter = null;
    public static XMLObjectParser DIRICHLET_PRIOR_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("sumToNumberOfElements", true), new ElementRule("countsParameter", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, 1, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return MultivariateDistributionLikelihood.DIRICHLET_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = false;
            if (xMLObject.hasAttribute(MultivariateDistributionLikelihood.SUM_TO_NUMBER_OF_ELEMENTS)) {
                bl = xMLObject.getBooleanAttribute(MultivariateDistributionLikelihood.SUM_TO_NUMBER_OF_ELEMENTS);
            }
            XMLObject xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.COUNTS);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            DirichletDistribution dirichletDistribution = new DirichletDistribution(parameter.getParameterValues(), bl);
            MultivariateDistributionLikelihood multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(dirichletDistribution);
            xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.DATA);
            for (int i = 0; i < xMLObject2.getChildCount(); ++i) {
                if (!(xMLObject2.getChild(i) instanceof Parameter)) {
                    throw new XMLParseException("illegal element in " + xMLObject.getName() + " element " + xMLObject2.getName());
                }
                multivariateDistributionLikelihood.addData((Parameter)xMLObject2.getChild(i));
            }
            return multivariateDistributionLikelihood;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the likelihood of some data under a Dirichlet distribution.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }
    };
    public static XMLObjectParser INV_WISHART_PRIOR_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("df"), new ElementRule("scaleMatrix", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class)})};

        @Override
        public String getParserName() {
            return MultivariateDistributionLikelihood.INV_WISHART_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n = xMLObject.getIntegerAttribute(MultivariateDistributionLikelihood.DF);
            XMLObject xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.SCALE_MATRIX);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            InverseWishartDistribution inverseWishartDistribution = new InverseWishartDistribution(n, matrixParameter.getParameterAsMatrix());
            MultivariateDistributionLikelihood multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(inverseWishartDistribution);
            xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.DATA);
            for (int i = 0; i < xMLObject2.getChildCount(); ++i) {
                if (!(xMLObject2.getChild(i) instanceof MatrixParameter)) {
                    throw new XMLParseException("illegal element in " + xMLObject.getName() + " element " + xMLObject2.getName());
                }
                multivariateDistributionLikelihood.addData((MatrixParameter)xMLObject2.getChild(i));
            }
            return multivariateDistributionLikelihood;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the likelihood of some data under an Inverse-Wishart distribution.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }
    };
    public static XMLObjectParser WISHART_PRIOR_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("nonInformative", true), AttributeRule.newDoubleRule("df", true), new ElementRule("scaleMatrix", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class)}, true), new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class, 1, Integer.MAX_VALUE)})};

        @Override
        public String getParserName() {
            return MultivariateDistributionLikelihood.WISHART_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MultivariateDistributionLikelihood multivariateDistributionLikelihood;
            int n;
            XMLObject xMLObject2;
            if (xMLObject.hasAttribute(MultivariateDistributionLikelihood.NON_INFORMATIVE) && xMLObject.getBooleanAttribute(MultivariateDistributionLikelihood.NON_INFORMATIVE)) {
                xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.DATA);
                n = ((MatrixParameter)xMLObject2.getChild(0)).getColumnDimension();
                multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(new WishartDistribution(n));
            } else {
                if (!xMLObject.hasAttribute(MultivariateDistributionLikelihood.DF) || !xMLObject.hasChildNamed(MultivariateDistributionLikelihood.SCALE_MATRIX)) {
                    throw new XMLParseException("Must specify both a df and scaleMatrix");
                }
                double d = xMLObject.getDoubleAttribute(MultivariateDistributionLikelihood.DF);
                XMLObject xMLObject3 = xMLObject.getChild(MultivariateDistributionLikelihood.SCALE_MATRIX);
                MatrixParameter matrixParameter = (MatrixParameter)xMLObject3.getChild(MatrixParameter.class);
                multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(new WishartDistribution(d, matrixParameter.getParameterAsMatrix()));
            }
            xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.DATA);
            for (n = 0; n < xMLObject2.getChildCount(); ++n) {
                if (!(xMLObject2.getChild(n) instanceof MatrixParameter)) {
                    throw new XMLParseException("illegal element in " + xMLObject.getName() + " element " + xMLObject2.getName());
                }
                multivariateDistributionLikelihood.addData((MatrixParameter)xMLObject2.getChild(n));
            }
            return multivariateDistributionLikelihood;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the likelihood of some data under a Wishart distribution.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }
    };
    public static XMLObjectParser MULTIVARIATE_LIKELIHOOD_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("distribution", new XMLSyntaxRule[]{new ElementRule(ParametricMultivariateDistributionModel.class)}), AttributeRule.newBooleanRule("dataAsMatrix", true), new ElementRule(Transform.ParsedTransform.class, 0, Integer.MAX_VALUE), new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(Parameter.class, 1, Integer.MAX_VALUE)}, true)};

        @Override
        public String getParserName() {
            return MultivariateDistributionLikelihood.MULTIVARIATE_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            XMLObject xMLObject2 = xMLObject.getChild("distribution");
            ParametricMultivariateDistributionModel parametricMultivariateDistributionModel = (ParametricMultivariateDistributionModel)xMLObject2.getChild(ParametricMultivariateDistributionModel.class);
            int n = parametricMultivariateDistributionModel.getMean().length;
            Transform[] transformArray = MultivariateDistributionLikelihood.parseListOfTransforms(xMLObject, n);
            MultivariateDistributionLikelihood multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(xMLObject.getId(), parametricMultivariateDistributionModel, transformArray);
            boolean bl = xMLObject.getAttribute(MultivariateDistributionLikelihood.DATA_AS_MATRIX, false);
            xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.DATA);
            if (xMLObject2 != null) {
                for (int i = 0; i < xMLObject2.getChildCount(); ++i) {
                    if (xMLObject2.getChild(i) instanceof Parameter) {
                        Parameter parameter = (Parameter)xMLObject2.getChild(i);
                        if (parameter instanceof MatrixParameter) {
                            MatrixParameter matrixParameter = (MatrixParameter)parameter;
                            if (bl) {
                                multivariateDistributionLikelihood.addData(matrixParameter);
                                continue;
                            }
                            if (matrixParameter.getParameter(0).getDimension() != parametricMultivariateDistributionModel.getMean().length) {
                                throw new XMLParseException("dim(" + parameter.getStatisticName() + ") = " + matrixParameter.getParameter(0).getDimension() + " is not equal to dim(" + parametricMultivariateDistributionModel.getType() + ") = " + parametricMultivariateDistributionModel.getMean().length + " in " + xMLObject.getName() + "element");
                            }
                            for (int j = 0; j < matrixParameter.getParameterCount(); ++j) {
                                multivariateDistributionLikelihood.addData(matrixParameter.getParameter(j));
                            }
                            continue;
                        }
                        if (parameter.getDimension() != parametricMultivariateDistributionModel.getMean().length) {
                            throw new XMLParseException("dim(" + parameter.getStatisticName() + ") = " + parameter.getDimension() + " is not equal to dim(" + parametricMultivariateDistributionModel.getType() + ") = " + parametricMultivariateDistributionModel.getMean().length + " in " + xMLObject.getName() + "element");
                        }
                        multivariateDistributionLikelihood.addData(parameter);
                        continue;
                    }
                    throw new XMLParseException("illegal element in " + xMLObject.getName() + " element");
                }
            }
            return multivariateDistributionLikelihood;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the likelihood of some data under a given multivariate distribution.";
        }

        @Override
        public Class getReturnType() {
            return MultivariateDistributionLikelihood.class;
        }
    };
    public static XMLObjectParser MVN_PRIOR_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("meanParameter", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("precisionParameter", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class)}), new ElementRule(Transform.ParsedTransform.class, 0, Integer.MAX_VALUE), new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(Parameter.class, 1, Integer.MAX_VALUE)}, true)};

        @Override
        public String getParserName() {
            return MultivariateDistributionLikelihood.MVN_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            XMLObject xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.MVN_MEAN);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.MVN_PRECISION);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            if (parameter.getDimension() != matrixParameter.getRowDimension() || parameter.getDimension() != matrixParameter.getColumnDimension()) {
                throw new XMLParseException("Mean and precision have wrong dimensions in " + xMLObject.getName() + " element");
            }
            Transform transform = Transform.Util.parseTransform(xMLObject);
            Transform.MultivariateTransform multivariateTransform = null;
            Transform[] transformArray = null;
            if (transform != null && transform.isMultivariate()) {
                multivariateTransform = (Transform.MultivariateTransform)transform;
            } else {
                transformArray = MultivariateDistributionLikelihood.parseListOfTransforms(xMLObject, parameter.getDimension());
            }
            MultivariateDistributionLikelihood multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(new MultivariateNormalDistribution(parameter.getParameterValues(), matrixParameter.getParameterAsMatrix()), transformArray, multivariateTransform);
            xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.DATA);
            if (xMLObject2 != null) {
                for (int i = 0; i < xMLObject2.getChildCount(); ++i) {
                    if (xMLObject2.getChild(i) instanceof Parameter) {
                        Parameter parameter2 = (Parameter)xMLObject2.getChild(i);
                        if (parameter2 instanceof MatrixParameter) {
                            MatrixParameter matrixParameter2 = (MatrixParameter)parameter2;
                            if (matrixParameter2.getParameter(0).getDimension() != parameter.getDimension()) {
                                throw new XMLParseException("dim(" + parameter2.getStatisticName() + ") = " + matrixParameter2.getParameter(0).getDimension() + " is not equal to dim(" + parameter.getStatisticName() + ") = " + parameter.getDimension() + " in " + xMLObject.getName() + "element");
                            }
                            for (int j = 0; j < matrixParameter2.getParameterCount(); ++j) {
                                multivariateDistributionLikelihood.addData(matrixParameter2.getParameter(j));
                            }
                            continue;
                        }
                        if (parameter2.getDimension() != parameter.getDimension()) {
                            throw new XMLParseException("dim(" + parameter2.getStatisticName() + ") = " + parameter2.getDimension() + " is not equal to dim(" + parameter.getStatisticName() + ") = " + parameter.getDimension() + " in " + xMLObject.getName() + "element");
                        }
                        multivariateDistributionLikelihood.addData(parameter2);
                        continue;
                    }
                    throw new XMLParseException("illegal element in " + xMLObject.getName() + " element");
                }
            }
            return multivariateDistributionLikelihood;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the likelihood of some data under a given multivariate-normal distribution.";
        }

        @Override
        public Class getReturnType() {
            return MultivariateDistributionLikelihood.class;
        }
    };
    public static XMLObjectParser MVGAMMA_PRIOR_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new XORRule(new ElementRule("shapeParameter", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("meanParameter", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})), new XORRule(new ElementRule("scaleParameter", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("coefficientOfVariation", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})), new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(Parameter.class, 1, Integer.MAX_VALUE)})};

        @Override
        public String getParserName() {
            return MultivariateDistributionLikelihood.MVGAMMA_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Object object;
            double[] dArray;
            double[] dArray2;
            Object object2;
            if (xMLObject.hasChildNamed("shapeParameter")) {
                object2 = xMLObject.getChild("shapeParameter");
                dArray2 = ((Parameter)((XMLObject)object2).getChild(Parameter.class)).getParameterValues();
                if (dArray2.length != (dArray = ((Parameter)((XMLObject)(object2 = xMLObject.getChild(MultivariateDistributionLikelihood.MVGAMMA_SCALE))).getChild(Parameter.class)).getParameterValues()).length) {
                    throw new XMLParseException("Shape and scale have wrong dimensions in " + xMLObject.getName() + " element");
                }
            } else {
                double[] dArray3;
                object2 = xMLObject.getChild(MultivariateDistributionLikelihood.MVN_MEAN);
                object = ((Parameter)((XMLObject)object2).getChild(Parameter.class)).getParameterValues();
                if (((double[])object).length != (dArray3 = ((Parameter)((XMLObject)(object2 = xMLObject.getChild(MultivariateDistributionLikelihood.MVN_CV))).getChild(Parameter.class)).getParameterValues()).length) {
                    throw new XMLParseException("Mean and CV have wrong dimensions in " + xMLObject.getName() + " element");
                }
                int n = ((double[])object).length;
                dArray2 = new double[n];
                dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    double d = dArray3[i] * dArray3[i];
                    dArray2[i] = 1.0 / d;
                    dArray[i] = d * object[i];
                }
            }
            object2 = new MultivariateDistributionLikelihood(new MultivariateGammaDistribution(dArray2, dArray));
            object = xMLObject.getChild(MultivariateDistributionLikelihood.DATA);
            for (int i = 0; i < object.getChildCount(); ++i) {
                if (object.getChild(i) instanceof Parameter) {
                    Parameter parameter = (Parameter)object.getChild(i);
                    ((MultivariateDistributionLikelihood)object2).addData(parameter);
                    if (parameter.getDimension() == dArray2.length) continue;
                    throw new XMLParseException("dim(" + parameter.getStatisticName() + ") != " + dArray2.length + " in " + xMLObject.getName() + "element");
                }
                throw new XMLParseException("illegal element in " + xMLObject.getName() + " element");
            }
            return object2;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the likelihood of some data under a given multivariate-gamma distribution.";
        }

        @Override
        public Class getReturnType() {
            return MultivariateDistributionLikelihood.class;
        }
    };
    public static XMLObjectParser TREE_TRAIT_MODEL = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("conditionOnRoot", true), new ElementRule(FullyConjugateMultivariateTraitLikelihood.class)};

        @Override
        public String getParserName() {
            return MultivariateDistributionLikelihood.TREE_TRAIT_NORMAL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeTraitNormalDistributionModel treeTraitNormalDistributionModel;
            boolean bl = xMLObject.getAttribute(MultivariateDistributionLikelihood.CONDITION, false);
            FullyConjugateMultivariateTraitLikelihood fullyConjugateMultivariateTraitLikelihood = (FullyConjugateMultivariateTraitLikelihood)xMLObject.getChild(FullyConjugateMultivariateTraitLikelihood.class);
            if (xMLObject.getChild(MultivariateDistributionLikelihood.ROOT_VALUE) != null) {
                XMLObject xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.ROOT_VALUE);
                Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
                treeTraitNormalDistributionModel = new TreeTraitNormalDistributionModel(fullyConjugateMultivariateTraitLikelihood, parameter, bl);
            } else {
                treeTraitNormalDistributionModel = new TreeTraitNormalDistributionModel(fullyConjugateMultivariateTraitLikelihood, bl);
            }
            return treeTraitNormalDistributionModel;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Parses TreeTraitNormalDistributionModel";
        }

        @Override
        public Class getReturnType() {
            return TreeTraitNormalDistributionModel.class;
        }
    };
    public static XMLObjectParser TREE_TRAIT_DISTRIBUTION = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeTraitNormalDistributionModel.class), new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(Parameter.class, 1, Integer.MAX_VALUE)})};

        @Override
        public String getParserName() {
            return MultivariateDistributionLikelihood.TREE_TRAIT;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeTraitNormalDistributionModel treeTraitNormalDistributionModel = (TreeTraitNormalDistributionModel)xMLObject.getChild(TreeTraitNormalDistributionModel.class);
            MultivariateDistributionLikelihood multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(treeTraitNormalDistributionModel);
            XMLObject xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.DATA);
            for (int i = 0; i < xMLObject2.getChildCount(); ++i) {
                if (!(xMLObject2.getChild(i) instanceof Parameter)) {
                    throw new XMLParseException("illegal element in " + xMLObject.getName() + " element " + xMLObject2.getName());
                }
                multivariateDistributionLikelihood.addData((Parameter)xMLObject2.getChild(i));
            }
            return multivariateDistributionLikelihood;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the likelihood of some data under a given multivariate-gamma distribution.";
        }

        @Override
        public Class getReturnType() {
            return MultivariateDistributionLikelihood.class;
        }
    };
    public static XMLObjectParser DETERMINANT_PRIOR_PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("shapeParameter");
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
            int n = matrixParameterInterface.getRowDimension();
            if (matrixParameterInterface.getColumnDimension() != n) {
                throw new XMLParseException("matrix must be square");
            }
            MultivariateDistributionLikelihood multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(new ConstrainedDeterminantDistributionModel(d, n));
            multivariateDistributionLikelihood.addData(matrixParameterInterface);
            return multivariateDistributionLikelihood;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{AttributeRule.newDoubleRule("shapeParameter", true), new ElementRule(MatrixParameterInterface.class)};
        }

        @Override
        public String getParserDescription() {
            return "Calculates p(X) = c * det(X)^a (currently omits normalization constant c)";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }

        @Override
        public String getParserName() {
            return MultivariateDistributionLikelihood.DETERMINANT_PRIOR;
        }
    };
    public static XMLObjectParser LKJ_PRIOR_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("nonInformative", true), AttributeRule.newDoubleRule("shapeParameter", true), new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(Parameter.class, 1, Integer.MAX_VALUE)})};

        @Override
        public String getParserName() {
            return MultivariateDistributionLikelihood.LKJ_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MultivariateDistributionLikelihood multivariateDistributionLikelihood;
            if (!xMLObject.hasAttribute(MultivariateDistributionLikelihood.DIMENSION)) {
                throw new XMLParseException("Must specify a shape parameter.");
            }
            int n = xMLObject.getIntegerAttribute(MultivariateDistributionLikelihood.DIMENSION);
            boolean bl = xMLObject.getAttribute(MultivariateDistributionLikelihood.CHOLESKY, true);
            if (xMLObject.hasAttribute(MultivariateDistributionLikelihood.NON_INFORMATIVE) && xMLObject.getBooleanAttribute(MultivariateDistributionLikelihood.NON_INFORMATIVE)) {
                multivariateDistributionLikelihood = bl ? new MultivariateDistributionLikelihood(new LKJCholeskyCorrelationDistribution(n)) : new MultivariateDistributionLikelihood(new LKJCorrelationDistribution(n));
            } else {
                if (!xMLObject.hasAttribute("shapeParameter")) {
                    throw new XMLParseException("Must specify a shape parameter.");
                }
                double d = xMLObject.getDoubleAttribute("shapeParameter");
                multivariateDistributionLikelihood = bl ? new MultivariateDistributionLikelihood(new LKJCholeskyCorrelationDistribution(n, d)) : new MultivariateDistributionLikelihood(new LKJCorrelationDistribution(n, d));
            }
            XMLObject xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.DATA);
            for (int i = 0; i < xMLObject2.getChildCount(); ++i) {
                if (xMLObject2.getChild(i) instanceof CompoundSymmetricMatrix) {
                    CompoundSymmetricMatrix compoundSymmetricMatrix = (CompoundSymmetricMatrix)xMLObject2.getChild(i);
                    multivariateDistributionLikelihood.addData(compoundSymmetricMatrix.getOffDiagonalParameter());
                    continue;
                }
                if (xMLObject2.getChild(i) instanceof Parameter) {
                    multivariateDistributionLikelihood.addData((Parameter)xMLObject2.getChild(i));
                    continue;
                }
                throw new XMLParseException("illegal element in " + xMLObject.getName() + " element " + xMLObject2.getName());
            }
            return multivariateDistributionLikelihood;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the likelihood of some data under a LKJ distribution.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }
    };
    public static XMLObjectParser MV_LOG_NORMAL_PRIOR_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(Parameter.class, 1, Integer.MAX_VALUE)})};

        @Override
        public String getParserName() {
            return MultivariateDistributionLikelihood.MV_LOG_NORMAL_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n = xMLObject.getIntegerAttribute(MultivariateDistributionLikelihood.DIMENSION);
            double d = xMLObject.getDoubleAttribute("mean");
            double d2 = xMLObject.getDoubleAttribute("stdev");
            LogNormalDistribution logNormalDistribution = new LogNormalDistribution(d, d2);
            MultivariateDistributionLikelihood multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(new MultivariateLogNormalDistribution(logNormalDistribution, n));
            XMLObject xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.DATA);
            for (int i = 0; i < xMLObject2.getChildCount(); ++i) {
                if (!(xMLObject2.getChild(i) instanceof Parameter)) {
                    throw new XMLParseException("illegal element in " + xMLObject.getName() + " element " + xMLObject2.getName());
                }
                multivariateDistributionLikelihood.addData((Parameter)xMLObject2.getChild(i));
            }
            return multivariateDistributionLikelihood;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the likelihood of some data under a multivariate log normal distribution.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }
    };
    public static XMLObjectParser SPHERICAL_BETA_PRIOR_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("nonInformative", true), AttributeRule.newDoubleRule("shapeParameter", true), new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(Parameter.class, 1, Integer.MAX_VALUE)})};

        @Override
        public String getParserName() {
            return MultivariateDistributionLikelihood.SPHERICAL_BETA_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            XMLObject xMLObject2;
            MultivariateDistributionLikelihood multivariateDistributionLikelihood = null;
            double d = 1.0;
            if (!xMLObject.hasAttribute(MultivariateDistributionLikelihood.NON_INFORMATIVE) || !xMLObject.getBooleanAttribute(MultivariateDistributionLikelihood.NON_INFORMATIVE)) {
                if (!xMLObject.hasAttribute("shapeParameter")) {
                    throw new XMLParseException("Must specify a shape parameter.");
                }
                d = xMLObject.getDoubleAttribute("shapeParameter");
            }
            if ((xMLObject2 = xMLObject.getChild(MultivariateDistributionLikelihood.DATA)) != null) {
                for (int i = 0; i < xMLObject2.getChildCount(); ++i) {
                    if (xMLObject2.getChild(i) instanceof Parameter) {
                        Parameter parameter = (Parameter)xMLObject2.getChild(i);
                        if (parameter instanceof MatrixParameter) {
                            MatrixParameter matrixParameter = (MatrixParameter)parameter;
                            int n = matrixParameter.getColumnDimension();
                            if (matrixParameter.getRowDimension() != n - 1) {
                                throw new XMLParseException("The Matricial Spherical Beta distribution can only be applied to a matrix with P columns each of dimension P-1.");
                            }
                            multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(new SphericalBetaDistribution(n - 1, d));
                            for (int j = 0; j < n; ++j) {
                                multivariateDistributionLikelihood.addData(matrixParameter.getParameter(j));
                            }
                            continue;
                        }
                        int n = parameter.getDimension();
                        multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(new SphericalBetaDistribution(n, d));
                        multivariateDistributionLikelihood.addData(parameter);
                        continue;
                    }
                    throw new XMLParseException("illegal element in " + xMLObject.getName() + " element");
                }
            }
            return multivariateDistributionLikelihood;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the likelihood of some data under a spherical beta distribution.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }
    };

    public MultivariateDistributionLikelihood(String string, ParametricMultivariateDistributionModel parametricMultivariateDistributionModel) {
        this(string, parametricMultivariateDistributionModel, null, null);
    }

    public MultivariateDistributionLikelihood(String string, ParametricMultivariateDistributionModel parametricMultivariateDistributionModel, Transform[] transformArray) {
        this(string, parametricMultivariateDistributionModel, transformArray, null);
    }

    public MultivariateDistributionLikelihood(String string, ParametricMultivariateDistributionModel parametricMultivariateDistributionModel, Transform[] transformArray, Transform.MultivariateTransform multivariateTransform) {
        super(parametricMultivariateDistributionModel);
        assert (multivariateTransform == null || transformArray == null) : "Transform[] and MultivatiateTransform cannot be simulataneously specified.";
        this.distribution = multivariateTransform == null ? parametricMultivariateDistributionModel : new TransformedMultivariateDistribution(parametricMultivariateDistributionModel, multivariateTransform);
        this.transforms = transformArray;
    }

    public MultivariateDistributionLikelihood(String string, MultivariateDistribution multivariateDistribution) {
        this(string, multivariateDistribution, null, null);
    }

    public MultivariateDistributionLikelihood(String string, MultivariateDistribution multivariateDistribution, Transform[] transformArray) {
        this(string, multivariateDistribution, transformArray, null);
    }

    public MultivariateDistributionLikelihood(String string, MultivariateDistribution multivariateDistribution, Transform.MultivariateTransform multivariateTransform) {
        this(string, multivariateDistribution, null, multivariateTransform);
    }

    public MultivariateDistributionLikelihood(String string, MultivariateDistribution multivariateDistribution, Transform[] transformArray, Transform.MultivariateTransform multivariateTransform) {
        super(new DefaultModel(string));
        assert (multivariateTransform == null || transformArray == null) : "Transform[] and MultivatiateTransform cannot be simulataneously specified.";
        this.distribution = multivariateTransform == null ? multivariateDistribution : new TransformedMultivariateDistribution(multivariateDistribution, multivariateTransform);
        this.transforms = transformArray;
    }

    public MultivariateDistributionLikelihood(MultivariateDistribution multivariateDistribution) {
        this(multivariateDistribution, null, null);
    }

    public MultivariateDistributionLikelihood(MultivariateDistribution multivariateDistribution, Transform[] transformArray) {
        this(multivariateDistribution, transformArray, null);
    }

    public MultivariateDistributionLikelihood(MultivariateDistribution multivariateDistribution, Transform.MultivariateTransform multivariateTransform) {
        this(multivariateDistribution, null, multivariateTransform);
    }

    public MultivariateDistributionLikelihood(MultivariateDistribution multivariateDistribution, Transform[] transformArray, Transform.MultivariateTransform multivariateTransform) {
        this(multivariateDistribution.getType(), multivariateDistribution, transformArray, multivariateTransform);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.getLogLikelihood() + ")";
    }

    @Override
    public double calculateLogLikelihood() {
        double d = 0.0;
        for (Attribute attribute : this.dataList) {
            double[] dArray = (double[])attribute.getAttributeValue();
            if (this.transforms != null) {
                double[] dArray2 = new double[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    d += this.transforms[i].logJacobian(dArray[i]);
                    dArray2[i] = this.transforms[i].transform(dArray[i]);
                }
                d += this.distribution.logPdf(dArray2);
                continue;
            }
            d += this.distribution.logPdf(dArray);
        }
        return d;
    }

    public void addData(Parameter parameter) {
        this.parameter = parameter;
        this.addData((Attribute<double[]>)parameter);
    }

    public Parameter getDataParameter() {
        return this.parameter;
    }

    @Override
    public void addData(Attribute<double[]> attribute) {
        super.addData(attribute);
        if (attribute instanceof Variable && this.getModel() instanceof DefaultModel) {
            ((DefaultModel)this.getModel()).addVariable((Variable)((Object)attribute));
        }
    }

    public MultivariateDistribution getDistribution() {
        return this.distribution;
    }

    public static Transform[] parseListOfTransforms(XMLObject xMLObject, int n) throws XMLParseException {
        Transform[] transformArray = null;
        boolean bl = false;
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            if (!(xMLObject.getChild(i) instanceof Transform.ParsedTransform)) continue;
            Transform.ParsedTransform parsedTransform = (Transform.ParsedTransform)xMLObject.getChild(i);
            if (transformArray == null) {
                transformArray = Transform.Util.getListOfNoTransforms(n);
            }
            parsedTransform.end = Math.max(parsedTransform.end, n);
            if (parsedTransform.start < 0 || parsedTransform.end < 0 || parsedTransform.start > parsedTransform.end) {
                throw new XMLParseException("Invalid bounds for transform in " + xMLObject.getId());
            }
            for (int j = parsedTransform.start; j < parsedTransform.end; j += parsedTransform.every) {
                transformArray[j] = parsedTransform.transform;
                bl = true;
            }
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder("Using distributional transforms in " + xMLObject.getId() + "\n");
            for (int i = 0; i < transformArray.length; ++i) {
                if (transformArray[i] == Transform.NONE) continue;
                stringBuilder.append("\t").append(transformArray[i].getTransformName()).append(" on index ").append(i + 1).append("\n");
            }
            Logger.getLogger("dr.utils.Transform").info(stringBuilder.toString());
        }
        return transformArray;
    }
}

