/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.MathUtils;
import dr.math.distributions.MultivariateDistribution;
import dr.math.distributions.RandomGenerator;
import java.util.Arrays;

public class PointMassMixtureDistribution
implements MultivariateDistribution,
RandomGenerator {
    public static final String TYPE = "PointMassMixture";
    private final double[] weights;
    private final double[][] realizedValues;
    boolean weightsNormalized;
    private double[] probabilites;

    public PointMassMixtureDistribution(double[] dArray, double[][] dArray2, boolean bl) {
        this.weights = dArray;
        this.realizedValues = dArray2;
        this.weightsNormalized = bl;
        this.probabilites = this.computeProbabilities(dArray, bl);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public double[] computeProbabilities(double[] dArray, boolean bl) {
        int n;
        if (bl) {
            return dArray;
        }
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = dArray[n] / d;
        }
        return dArray;
    }

    @Override
    public double logPdf(double[] dArray) {
        return PointMassMixtureDistribution.logPdf(dArray, this.probabilites, this.realizedValues);
    }

    public static double logPdf(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n = dArray3.length;
        int n2 = dArray3[0].length;
        for (int i = 0; i < n2; ++i) {
            double[] dArray4 = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray4[j] = dArray3[j][i];
            }
            if (!Arrays.equals(dArray, dArray4)) continue;
            return Math.log(dArray2[i]);
        }
        return Math.log(0.0);
    }

    public double[][] getCovarianceMatrix() {
        return PointMassMixtureDistribution.getCovarianceMatrix(this.probabilites, this.realizedValues);
    }

    public static double[][] getCovarianceMatrix(double[] dArray, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        double[][] dArray3 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray3 = PointMassMixtureDistribution.addMatrices(dArray3, PointMassMixtureDistribution.multMatrixByScalar(dArray[i] * dArray[j], PointMassMixtureDistribution.multColumnVecByRowVec(PointMassMixtureDistribution.getCol(dArray2, i), PointMassMixtureDistribution.getCol(dArray2, j))));
            }
        }
        dArray3 = PointMassMixtureDistribution.addMatrices(dArray3, PointMassMixtureDistribution.multMatrixByScalar(-1.0, PointMassMixtureDistribution.multColumnVecByRowVec(PointMassMixtureDistribution.getMean(dArray, dArray2), PointMassMixtureDistribution.getMean(dArray, dArray2))));
        return dArray3;
    }

    @Override
    public double[][] getScaleMatrix() {
        return PointMassMixtureDistribution.getScaleMatrix(this.probabilites, this.realizedValues);
    }

    public static double[][] getScaleMatrix(double[] dArray, double[][] dArray2) {
        return PointMassMixtureDistribution.getCovarianceMatrix(dArray, dArray2);
    }

    @Override
    public double[] getMean() {
        return PointMassMixtureDistribution.getMean(this.probabilites, this.realizedValues);
    }

    public static double[] getMean(double[] dArray, double[][] dArray2) {
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[i].length; ++j) {
                dArray3[i] = dArray3[i] + dArray[j] * dArray2[i][j];
            }
        }
        return dArray3;
    }

    public static double[][] multMatrixByScalar(double d, double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                dArray[i][j] = d * dArray[i][j];
            }
        }
        return dArray;
    }

    public static double[][] multColumnVecByRowVec(double[] dArray, double[] dArray2) {
        double[][] dArray3 = new double[dArray.length][dArray2.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                dArray3[i][j] = dArray2[i] * dArray[j];
            }
        }
        return dArray3;
    }

    public static double[][] addMatrices(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = dArray[i][j] + dArray2[i][j];
            }
        }
        return dArray;
    }

    public static double[] getCol(double[][] dArray, int n) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i][n];
        }
        return dArray2;
    }

    @Override
    public Object nextRandom() {
        int n = MathUtils.randomChoicePDF(this.probabilites);
        return PointMassMixtureDistribution.getCol(this.realizedValues, n);
    }

    @Override
    public double logPdf(Object object) {
        double[] dArray = (double[])object;
        return this.logPdf(dArray);
    }
}

