% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{call_cpp}
\alias{call_cpp}
\title{R interface to BeviMed c++ MCMC procedure}
\usage{
call_cpp(
  samples_per_chain,
  y,
  block_starts,
  block_ends,
  cases,
  counts,
  min_ac,
  tau_shape,
  pi_shape,
  omega_shape,
  temperatures,
  z0_matrix,
  estimate_omega,
  logit_omegas,
  logit_omega_proposal_sds,
  variant_weights,
  estimate_phi,
  log_phis,
  log_phi_mean,
  log_phi_sd,
  log_phi_proposal_sds,
  chain_swaps_per_cycle,
  annealing,
  tandem_variant_updates,
  comphet_variant_block_starts,
  comphet_variant_block_ends,
  comphet_variants,
  return_z_trace,
  return_x_trace,
  burn = 0,
  check = TRUE
)
}
\arguments{
\item{samples_per_chain}{Number of samples to draw from each chain.}

\item{y}{Logical vector of subject affectedness status.}

\item{block_starts}{Integer vector of k 0-indexed start positions (with respect to \code{cases} and \code{counts}) for contiguous blocks relating to the k variants.}

\item{block_ends}{Integer vector of (exclusive) k 0-indexed end positions.}

\item{cases}{0 based vector of case indices with respect to y.}

\item{counts}{Vector of variant counts.}

\item{min_ac}{Integer vector with a length equalling the number of individuals or length \code{1} (in which case the given value is used for all individuals) giving the minimum number of alleles at pathogenic variant sites each individual requires in order to classify as having a `pathogenic allele configuration'. Thus, this parameter encodes the mode of inheritance. For instance, setting this parameter to \code{1} corresponds to dominant inheritance. If there are differences in ploidy between individuals in the locus, it is necessary to set it on an sample level basis - e.g. to ensure sex is accounted for if the locus lies on the X chromosome.}

\item{tau_shape}{Beta distribution parameterisation of benign variant configuration rate of affection, q.}

\item{pi_shape}{Beta distribution parameterisation of pathogenic variant configuration rate of affection, p.}

\item{omega_shape}{Beta distribution of global rate of pathogenicty of variants in gene given pathogenicity of gene, omega.}

\item{temperatures}{Numeric vector of temperatures of power posteriors. One chain will be created for each element of the vector at the corresponding temperature.}

\item{z0_matrix}{Matrix of logicals, where the rows are used as an initial zs for the chains.}

\item{estimate_omega}{Logical value determining whether to estimate the parameter omega.}

\item{logit_omegas}{Numeric vector of logit omega values, one value per chain.}

\item{logit_omega_proposal_sds}{Numeric vector of proposal standard deviations for Metropolis-Hastings sampling of logit omega parameter, one value per chain.}

\item{variant_weights}{Vector of log-odds off-sets for rates of pathogenicity of individual variants relative to the global rate, omega.}

\item{estimate_phi}{Logical value determining whether to estimate a scaling factor of \code{variant_weights}.}

\item{log_phis}{Numeric vector of log phi values, one value per chain.}

\item{log_phi_mean}{Mean for normal prior on scaling factor phi.}

\item{log_phi_sd}{SD for normal prior on scaling factor phi.}

\item{log_phi_proposal_sds}{Numeric vector of proposal standard deviations for Metropolis-Hastings sampling of log phi parameter, one value per chain.}

\item{chain_swaps_per_cycle}{Number of chain swaps to propose per update cycle.}

\item{annealing}{Logical value determining whether to anneal the chains, e.g. for optimisation.}

\item{tandem_variant_updates}{Number of tandem variant updates to make per update cycle.}

\item{comphet_variant_block_starts}{0-indexed start positions for contiguous blocks of variants in \code{comphet_variants}.}

\item{comphet_variant_block_ends}{As \code{comphet_variant_block_starts} for (exclusive) stop positions.}

\item{comphet_variants}{Integer vector giving variant numbers (0-based, i.e. between 0 and k-1). Used to pick pairs of variants for tandem updates from.}

\item{return_z_trace}{Logical value determining whether to store the z-vectors for each chain, which uses alot of memory, particularly if \code{samples_per_chain}, k and \code{length(temperatures)} are large.}

\item{return_x_trace}{Logical value determining whether to store the x variable determined by success samples of z. Potentially uses alot of memory, particularly if \code{samples_per_chain}, k and \code{length(temperatures)} are large.}

\item{burn}{Number of samples to drop from the start of the chain.}

\item{check}{Logical value indicating whether to perform validation on the arguments before calling the c++ function.}
}
\value{
Object of class \code{BeviMed_raw}, containing the output of the MCMC sampling.
}
\description{
Allows other functions in the package to call the c++ function passing arguments more succinctly and by name.
}
