% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IIS.R
\name{IIS}
\alias{IIS}
\title{IIS}
\usage{
IIS(
  microApath,
  metaApath,
  conf = NULL,
  groupInfo = NULL,
  nDFS = 0.4,
  nDS = 0.3,
  nES = 0.2,
  nAS = 0.1,
  NS = 2.5,
  r = 0.5,
  p_adjust = 0.05
)
}
\arguments{
\item{microApath}{A data frame including microbes and predicted KEGG pathways.}

\item{metaApath}{A data frame including metabolites with compound ID and predicted KEGG pathways from Meta2pathway function.}

\item{conf}{A data frame including confounders. Default value is NULL.}

\item{groupInfo}{A data frame including sample grouping information}

\item{nDFS}{A value indicated the weight of difference Score in the IIS formula. Default value is 0.4.}

\item{nDS}{A value indicated the weight of degree score in the IIS formula. Default value is 0.3.}

\item{nES}{A value indicated the weight of edge score in the IIS formula. Default value is 0.2.}

\item{nAS}{A value indicated the weight of abundance score in the IIS formula. Default value is 0.1.}

\item{NS}{A threshold value of IIS to identify the key nodes. Default value is 2.5.}

\item{r}{A threshold value of correlation coefficient to construct the network. Default value is 0.5.}

\item{p_adjust}{A threshold value of correlation adjust p value to construct the network. Default  value is 0.05.}
}
\value{
IIS_res A list including IIS and other sub-score results.
}
\description{
A function is used to calculates and identify the key nodes,the formula of IIS is:
              IIS= nDFS x DFS + nDS x DS + nES x ES + nAS x AS;
nDFS,nDS,nES,nAS indict the weight value of DFS,DS,ES and AS, and nDFS + nDS + nES + nAS = 1;
DFS means Difference Score;
DS means Degree Score;
ES means Edge Score;
AS means Abundance Score.
}
\examples{
IIScore <- IIS(microApath = micro.eg, metaApath = metabo.eg,
               conf = confounder.eg, groupInfo = groupInfo.eg)
}
