\name{distdisplayed}
\alias{distdisplayed}

\title{Compare Distance Displayed in Ordination Diagram with Distances of Distance Matrix}

\description{
This function compares the distance among sites as displayed in an ordination diagram (generated by \code{\link[vegan]{ordiplot}}) with the actual distances among sites as available from a distance matrix (as generated by \code{\link[vegan]{vegdist}}). 
}

\usage{
distdisplayed(x, ordiplot, distx = "bray", plotit = T, addit = F, 
    method = "spearman", permutations = 100, abline = F, gam = T, ...) 
}

\arguments{
  \item{x}{ Community data frame (with sites as rows, species as columns and species abundance as cell values) or distance matrix. }
  \item{ordiplot}{ Ordination diagram generated by \code{\link[vegan]{ordiplot}} or distance matrix. }
  \item{distx}{ Ecological distance used to calculated the distance matrix (theoretically the same distance as displayed in the ordination diagram); passed to \code{\link[vegan]{vegdist}} and partial match to "manhattan", "euclidean", "canberra", "bray", "kulczynski", "jaccard", "gower", "morisita", "horn", "mountford", "raup" , "binomial" or "chao". This argument is ignored in case that "x" is already a distance matrix. }
  \item{plotit}{ Should a plot comparing the distance in ordination diagram (or the distance matrix) with the distance from the distance matrix be generated (or not). }
  \item{addit}{ Should the GAM regression result be added to an existing plot (or not). }
  \item{method}{ Method for calculating the correlation between the ordination distance and the complete distance; from function \code{\link[vegan]{mantel}} passed to function \code{\link[stats]{cor}}: "pearson", "spearman" or "kendall". }
  \item{permutations}{ Number of permutations to assess the significance of the Mantel test; passed to \code{\link[vegan]{mantel}}. }
  \item{abline}{ Should a reference line (y=x) be added to the graph (or not). }
  \item{gam}{ Evaluate the correspondence between the original distance and the distance from the ordination diagram with GAMas estimated by \code{\link[mgcv]{gam}}. }
  \item{...}{ Other arguments passed to \code{\link[vegan]{mantel}}. }
}

\details{
This function compares the Euclidean distances (between sites) displayed in an ordination diagram with the distances of a distance matrix. Alternatively, the distances of one distance matrix are compared against the distances of another distance matrix.
 
These distances are compared by a Mantel test (\code{\link[vegan]{mantel}}) and (optionally) a GAM regression (\code{\link[mgcv]{gam}}). Optionally, a graph is provided compairing the distances and adding GAM results.
.
}

\value{
The function returns the results of a Mantel test and (optionally) the results of a GAM analysis.
}

\references{
Kindt, R. & Coe, R. (2005)
Tree diversity analysis: A manual and
  software for common statistical methods for ecological and
  biodiversity studies.
 
  \url{http://www.worldagroforestry.org/output/tree-diversity-analysis}
}   

\author{Roeland Kindt (World Agroforestry Centre)}

\examples{
library(vegan)
library(mgcv)
data(dune)
distmatrix <- vegdist(dune,method="kulc")
ordination.model1 <- cmdscale(distmatrix,k=2)
ordiplot1 <- ordiplot(ordination.model1)
distdisplayed(dune,ordiplot=ordiplot1,distx="kulc",plotit=TRUE,
    method="spearman",permutations=100,gam=TRUE)
}

\keyword{multivariate} 


