% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blanket_statsments.R
\name{table_blanket_statsments}
\alias{table_blanket_statsments}
\title{Table results of multiple different models with different sets of predictors}
\usage{
table_blanket_statsments(df, blanket_statsment_models)
}
\arguments{
\item{df}{data.frame containing the data set.}

\item{blanket_statsment_models}{list of models produced by blanket_statsments()}
}
\value{
data.frame with tabled results
}
\description{
Wraps blanket_stats. Run a list of models with different modalities/outcomes for a list of different predictor sets with the same covariables.
}
\examples{
data <- survival::lung
models_to_run <- list('OS' = list(
'outcome' = 'time', 'modality' = 'cox', 'event_censor' = 'status'),
'weight_loss' = list('outcome' = 'wt.loss', 'modality' = 'linear', 'event_censor' = NA))
predictor_sets <- list('age' = c('age'),'age_ecog' = c('age', 'ph.ecog'))
covariates = c('sex')
bl_stats <- blanket_statsments(data, models_to_run, predictor_sets, covariates)
tbl <- table_blanket_statsments(data, bl_stats)

}
\seealso{
[blanket_statsments()] for models and [table_predictors()] for tabling results
}
\author{
J. Peter Marquardt
}
